-- =============================================
-- Backup del Database: am
-- Data: 2025-12-11 16:21:15
-- Generato da: Laravel Backup Module
-- =============================================

SET FOREIGN_KEY_CHECKS=0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

-- =============================================
-- Struttura tabella `aliquote_iva`
-- =============================================

DROP TABLE IF EXISTS `aliquote_iva`;
CREATE TABLE `aliquote_iva` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codice` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `percentuale` decimal(5,2) NOT NULL,
  `descrizione` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attiva` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `aliquote_iva_codice_unique` (`codice`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `aliquote_iva` (5 righe)

INSERT INTO `aliquote_iva` (`id`, `codice`, `percentuale`, `descrizione`, `attiva`, `created_at`, `updated_at`) VALUES
(1, 'IVA22', 22.00, 'Aliquota ordinaria - 22%', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(2, 'IVA10', 10.00, 'Aliquota ridotta - 10%', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(3, 'IVA5', 5.00, 'Aliquota super ridotta - 5%', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(4, 'IVA4', 4.00, 'Aliquota minima - 4%', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(5, 'IVA0', 0.00, 'Esente - 0%', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37');

-- =============================================
-- Struttura tabella `article_distinta_base`
-- =============================================

DROP TABLE IF EXISTS `article_distinta_base`;
CREATE TABLE `article_distinta_base` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `article_id` bigint unsigned NOT NULL,
  `prodotto_finito_id` bigint unsigned NOT NULL,
  `quantita` decimal(10,3) NOT NULL DEFAULT '1.000',
  `unita_misura` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pz',
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `article_distinta_base_article_id_prodotto_finito_id_unique` (`article_id`,`prodotto_finito_id`),
  KEY `article_distinta_base_prodotto_finito_id_foreign` (`prodotto_finito_id`),
  CONSTRAINT `article_distinta_base_article_id_foreign` FOREIGN KEY (`article_id`) REFERENCES `articles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `article_distinta_base_prodotto_finito_id_foreign` FOREIGN KEY (`prodotto_finito_id`) REFERENCES `prodotti_finiti` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `article_distinta_base` (34 righe)

INSERT INTO `article_distinta_base` (`id`, `article_id`, `prodotto_finito_id`, `quantita`, `unita_misura`, `note`, `created_at`, `updated_at`) VALUES
(1, 1, 6, 1.000, 'pz', NULL, '2025-12-02 12:26:09', '2025-12-02 12:26:09'),
(2, 1, 1, 1.000, 'pz', NULL, '2025-12-02 12:26:09', '2025-12-02 12:26:09'),
(3, 1, 4, 1.000, 'pz', NULL, '2025-12-02 12:26:09', '2025-12-02 12:26:09'),
(4, 2, 1, 1.000, 'pz', NULL, '2025-12-02 12:27:04', '2025-12-02 12:27:04'),
(5, 2, 3, 1.000, 'pz', NULL, '2025-12-02 12:27:04', '2025-12-02 12:27:04'),
(6, 2, 5, 1.000, 'pz', NULL, '2025-12-02 12:27:04', '2025-12-02 12:27:04'),
(7, 3, 6, 1.000, 'pz', NULL, '2025-12-02 12:30:24', '2025-12-02 12:30:24'),
(8, 3, 1, 1.000, 'pz', NULL, '2025-12-02 12:30:24', '2025-12-02 12:30:24'),
(9, 3, 3, 1.000, 'pz', NULL, '2025-12-02 12:30:24', '2025-12-02 12:30:24'),
(10, 3, 4, 1.000, 'pz', NULL, '2025-12-02 12:30:24', '2025-12-02 12:30:24'),
(11, 3, 5, 1.000, 'pz', NULL, '2025-12-02 12:30:24', '2025-12-02 12:30:24'),
(12, 4, 6, 2.000, 'pz', NULL, '2025-12-02 12:33:27', '2025-12-02 12:33:27'),
(13, 4, 1, 1.000, 'pz', NULL, '2025-12-02 12:33:27', '2025-12-02 12:33:27'),
(14, 4, 3, 2.000, 'pz', NULL, '2025-12-02 12:33:27', '2025-12-02 12:33:27'),
(15, 4, 4, 2.000, 'pz', NULL, '2025-12-02 12:33:27', '2025-12-02 12:33:27'),
(16, 4, 5, 2.000, 'pz', NULL, '2025-12-02 12:33:27', '2025-12-02 12:33:27'),
(22, 5, 6, 4.000, 'pz', NULL, '2025-12-04 11:15:14', '2025-12-04 11:15:14'),
(23, 5, 1, 2.000, 'pz', NULL, '2025-12-04 11:15:14', '2025-12-04 11:15:14'),
(24, 5, 3, 4.000, 'pz', NULL, '2025-12-04 11:15:14', '2025-12-04 11:15:14'),
(25, 5, 4, 4.000, 'pz', NULL, '2025-12-04 11:15:14', '2025-12-04 11:15:14'),
(26, 5, 5, 4.000, 'pz', NULL, '2025-12-04 11:15:14', '2025-12-04 11:15:14'),
(27, 6, 2, 1.000, 'pz', NULL, '2025-12-04 11:16:57', '2025-12-04 11:16:57'),
(28, 6, 3, 10.000, 'pz', NULL, '2025-12-04 11:16:57', '2025-12-04 11:16:57'),
(29, 6, 5, 10.000, 'pz', NULL, '2025-12-04 11:16:57', '2025-12-04 11:16:57'),
(30, 7, 6, 10.000, 'pz', NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(31, 7, 1, 1.000, 'pz', NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(32, 7, 2, 1.000, 'pz', NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(33, 7, 3, 10.000, 'pz', NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(34, 7, 4, 10.000, 'pz', NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(35, 7, 5, 10.000, 'pz', NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(36, 8, 6, 2.000, 'pz', NULL, '2025-12-05 11:08:17', '2025-12-05 11:08:17'),
(37, 8, 4, 2.000, 'pz', NULL, '2025-12-05 11:08:17', '2025-12-05 11:08:17'),
(38, 9, 3, 2.000, 'pz', NULL, '2025-12-05 11:09:12', '2025-12-05 11:09:12'),
(39, 9, 5, 2.000, 'pz', NULL, '2025-12-05 11:09:12', '2025-12-05 11:09:12');

-- =============================================
-- Struttura tabella `article_documents`
-- =============================================

DROP TABLE IF EXISTS `article_documents`;
CREATE TABLE `article_documents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `article_id` bigint unsigned NOT NULL,
  `nome` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tipo di documento: modello_3d, datasheet, altro',
  `file_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_size` bigint unsigned DEFAULT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `article_documents_article_id_foreign` (`article_id`),
  CONSTRAINT `article_documents_article_id_foreign` FOREIGN KEY (`article_id`) REFERENCES `articles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `articles`
-- =============================================

DROP TABLE IF EXISTS `articles`;
CREATE TABLE `articles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codice` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` enum('materia_prima','semilavorato','prodotto_finito') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'materia_prima',
  `titolo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `barcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qrcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unita_misura_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `articles_codice_unique` (`codice`),
  UNIQUE KEY `articles_barcode_unique` (`barcode`),
  UNIQUE KEY `articles_qrcode_unique` (`qrcode`),
  KEY `articles_unita_misura_id_foreign` (`unita_misura_id`),
  CONSTRAINT `articles_unita_misura_id_foreign` FOREIGN KEY (`unita_misura_id`) REFERENCES `unita_di_misura` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `articles` (9 righe)

INSERT INTO `articles` (`id`, `codice`, `tipo`, `titolo`, `descrizione`, `barcode`, `qrcode`, `unita_misura_id`, `created_at`, `updated_at`) VALUES
(1, 'KIT-001', 'prodotto_finito', 'BASIC AAA ULTRA KIT', 'S-Charger Plus + AAA Captery + AAA CapteryBridge', NULL, NULL, NULL, '2025-12-02 12:26:09', '2025-12-02 12:26:09'),
(2, 'KIT-002', 'prodotto_finito', 'BASIC AA ULTRA KIT', 'S-Charger Plus + AA Captery + AA CapteryBridge', NULL, NULL, NULL, '2025-12-02 12:27:04', '2025-12-02 12:27:04'),
(3, 'KIT-003', 'prodotto_finito', 'Standard ULTRA KIT', 'S-Charger Plus + AA Captery+ AAACaptery+ AACapteryBridge + AAACapteryridge', NULL, NULL, NULL, '2025-12-02 12:30:24', '2025-12-02 12:30:24'),
(4, 'KIT-004', 'prodotto_finito', 'SUPREME ULTRA KIT', 'S-Charger Plus + 2 x CapteryAA + 2 x CapteryAAA + 2 x CapteryBridgeAA + 2 x CapteryridgeAAA', NULL, NULL, NULL, '2025-12-02 12:33:27', '2025-12-02 12:33:27'),
(5, 'KIT-005', 'prodotto_finito', 'DELUXE ULTRA KIT', 'S-Charger Plus + 4 x CapteryAA + 4 x CapteryAAA + 4 x CapteryBridgeAA + 4 x CapteryridgeAAA', NULL, NULL, NULL, '2025-12-04 11:02:54', '2025-12-04 11:15:14'),
(6, 'KIT-006', 'prodotto_finito', 'M-Charger Station Kit', 'M-Charger Station + 10x AA Captery ULTRA + 10xAA Captery Bridge', NULL, NULL, NULL, '2025-12-04 11:16:57', '2025-12-04 11:16:57'),
(7, 'KIT-007', 'prodotto_finito', 'Diamond Kit - Limited Edition', 'S-Charger Plus + M-Charger Station + CapterMeter + 10xAA Captery Ultra + 10xAA Captery Bridge+ 10xAAA Captery Ultra + 10xAAA Captery Bridge + 10xAdaptors.', NULL, NULL, NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(8, 'Kit-008', 'prodotto_finito', 'Captery AAA ULTRA KIT', '2xCaptery AAA + 2xCaptery Bridge AAA', NULL, NULL, NULL, '2025-12-05 11:08:17', '2025-12-05 11:08:17'),
(9, 'KIT-009', 'prodotto_finito', 'Captery AA ULTRA KIT', '2 x CapteryAA ULTRA + 2x Captery Bridge AA', NULL, NULL, NULL, '2025-12-05 11:09:12', '2025-12-05 11:09:12');

-- =============================================
-- Struttura tabella `cache`
-- =============================================

DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `cache_locks`
-- =============================================

DROP TABLE IF EXISTS `cache_locks`;
CREATE TABLE `cache_locks` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `clients`
-- =============================================

DROP TABLE IF EXISTS `clients`;
CREATE TABLE `clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nome` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `indirizzo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `citta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cap` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `provincia` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `partita_iva` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codice_fiscale` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `clients_nome_index` (`nome`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `clients` (5 righe)

INSERT INTO `clients` (`id`, `nome`, `email`, `telefono`, `indirizzo`, `citta`, `cap`, `provincia`, `partita_iva`, `codice_fiscale`, `note`, `created_at`, `updated_at`) VALUES
(1, 'Kickstarter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-02 13:01:20', '2025-12-02 13:01:20'),
(2, 'Wide Solution', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-03 11:32:09', '2025-12-03 11:32:09'),
(3, 'Rithema', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-05 10:57:02', '2025-12-05 10:57:02'),
(4, 'Massimiliano Censi', 'massimiliano.censi90@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-05 14:40:21', '2025-12-05 14:40:21'),
(5, 'DS', 'sprocket_man_@hotmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-05 17:37:42', '2025-12-05 17:37:42');

-- =============================================
-- Struttura tabella `distinta_base`
-- =============================================

DROP TABLE IF EXISTS `distinta_base`;
CREATE TABLE `distinta_base` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `prodotto_finito_id` bigint unsigned NOT NULL,
  `materia_prima_id` bigint unsigned NOT NULL,
  `quantita` decimal(10,3) NOT NULL DEFAULT '1.000',
  `unita_misura` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pz',
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `distinta_base_prodotto_finito_id_materia_prima_id_unique` (`prodotto_finito_id`,`materia_prima_id`),
  KEY `distinta_base_materia_prima_id_foreign` (`materia_prima_id`),
  CONSTRAINT `distinta_base_materia_prima_id_foreign` FOREIGN KEY (`materia_prima_id`) REFERENCES `materie_prime` (`id`) ON DELETE CASCADE,
  CONSTRAINT `distinta_base_prodotto_finito_id_foreign` FOREIGN KEY (`prodotto_finito_id`) REFERENCES `prodotti_finiti` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `distinta_base` (59 righe)

INSERT INTO `distinta_base` (`id`, `prodotto_finito_id`, `materia_prima_id`, `quantita`, `unita_misura`, `note`, `created_at`, `updated_at`) VALUES
(6, 1, 2, 1.000, '1 pz', NULL, '2025-12-02 19:53:48', '2025-12-02 19:53:48'),
(7, 1, 1, 1.000, '1 pz', NULL, '2025-12-02 19:54:08', '2025-12-02 19:54:08'),
(8, 1, 3, 1.000, '1 pz', NULL, '2025-12-02 19:54:16', '2025-12-02 19:54:16'),
(9, 2, 1, 10.000, '10 pz', NULL, '2025-12-02 19:56:20', '2025-12-02 19:56:20'),
(10, 2, 4, 10.000, 10, NULL, '2025-12-03 09:51:56', '2025-12-03 09:51:56'),
(11, 1, 5, 1.000, '1 pz', NULL, '2025-12-04 16:34:41', '2025-12-04 16:34:41'),
(12, 1, 27, 1.000, '1 pz', NULL, '2025-12-04 16:35:03', '2025-12-04 16:35:03'),
(13, 1, 36, 1.000, '1 pz', NULL, '2025-12-04 16:35:21', '2025-12-04 16:35:21'),
(14, 1, 8, 1.000, '1 pz', NULL, '2025-12-04 16:35:29', '2025-12-04 16:35:29'),
(15, 1, 24, 1.000, '1 pz', NULL, '2025-12-04 16:36:08', '2025-12-04 16:36:08'),
(16, 1, 33, 1.000, '1 pz', NULL, '2025-12-04 16:36:20', '2025-12-04 16:36:20'),
(17, 1, 26, 1.000, '1 pz', NULL, '2025-12-04 16:36:31', '2025-12-04 16:36:31'),
(18, 1, 32, 1.000, '1 pz', NULL, '2025-12-04 16:36:49', '2025-12-04 16:36:49'),
(19, 1, 7, 1.000, '1 pz', NULL, '2025-12-04 16:36:57', '2025-12-04 16:36:57'),
(20, 1, 10, 1.000, '1 pz', NULL, '2025-12-04 16:37:12', '2025-12-04 16:37:12'),
(21, 1, 34, 1.000, '1 pz', NULL, '2025-12-04 16:37:53', '2025-12-04 16:37:53'),
(22, 1, 29, 1.000, '1 pz', NULL, '2025-12-04 16:38:11', '2025-12-04 16:38:11'),
(23, 2, 20, 1.000, '1 pz', NULL, '2025-12-04 16:47:43', '2025-12-04 16:47:43'),
(24, 2, 21, 1.000, '1 pz', NULL, '2025-12-04 16:47:59', '2025-12-04 16:47:59'),
(25, 1, 41, 1.000, 'pz', NULL, '2025-12-05 09:06:05', '2025-12-05 09:06:05'),
(26, 6, 18, 1.000, 'pz', NULL, '2025-12-05 09:13:17', '2025-12-05 09:13:17'),
(27, 6, 19, 1.000, 'pz', NULL, '2025-12-05 09:13:49', '2025-12-05 09:13:49'),
(28, 6, 37, 1.000, 'pz', NULL, '2025-12-05 09:15:48', '2025-12-05 09:15:48'),
(29, 6, 39, 1.000, 'pz', NULL, '2025-12-05 09:16:00', '2025-12-05 09:16:00'),
(30, 2, 42, 1.000, 'pz', NULL, '2025-12-05 11:07:29', '2025-12-05 11:07:29'),
(31, 2, 26, 1.000, 'pz', NULL, '2025-12-05 11:07:59', '2025-12-05 11:07:59'),
(32, 2, 25, 10.000, 'pz', NULL, '2025-12-05 11:09:25', '2025-12-05 11:09:25'),
(33, 2, 33, 6.000, 'pz', NULL, '2025-12-05 11:10:01', '2025-12-05 11:10:01'),
(34, 2, 35, 1.000, 'pz', NULL, '2025-12-05 11:10:24', '2025-12-05 11:10:24'),
(35, 2, 32, 6.000, 'pz', NULL, '2025-12-05 11:11:28', '2025-12-05 11:11:28'),
(36, 3, 16, 1.000, 'pz', NULL, '2025-12-05 11:12:22', '2025-12-05 11:12:22'),
(37, 3, 17, 1.000, 'pz', NULL, '2025-12-05 11:12:31', '2025-12-05 11:12:31'),
(38, 3, 15, 1.000, 'pz', NULL, '2025-12-05 11:12:49', '2025-12-05 11:12:49'),
(39, 3, 14, 1.000, 'pz', NULL, '2025-12-05 11:12:55', '2025-12-05 11:12:55'),
(40, 3, 37, 1.000, 'pz', NULL, '2025-12-05 11:13:16', '2025-12-05 11:13:16'),
(41, 3, 38, 1.000, 'pz', NULL, '2025-12-05 11:13:34', '2025-12-05 11:13:34'),
(42, 3, 43, 1.000, 'pz', NULL, '2025-12-05 11:26:07', '2025-12-05 11:26:07'),
(43, 4, 44, 1.000, 'pz', NULL, '2025-12-05 11:27:09', '2025-12-05 11:27:09'),
(44, 4, 18, 1.000, 'pz', NULL, '2025-12-05 11:27:19', '2025-12-05 11:27:19'),
(45, 4, 19, 1.000, 'pz', NULL, '2025-12-05 11:27:34', '2025-12-05 11:27:34'),
(46, 4, 37, 1.000, 'pz', NULL, '2025-12-05 11:28:04', '2025-12-05 11:28:04'),
(47, 4, 39, 1.000, 'pz', NULL, '2025-12-05 11:28:16', '2025-12-05 11:28:16'),
(48, 4, 31, 1.000, 'pz', NULL, '2025-12-05 11:29:14', '2025-12-05 11:29:14'),
(49, 4, 12, 1.000, 'pz', NULL, '2025-12-05 11:30:02', '2025-12-05 11:30:02'),
(50, 4, 13, 1.000, 'pz', NULL, '2025-12-05 11:30:16', '2025-12-05 11:30:16'),
(51, 6, 45, 1.000, 'pz', NULL, '2025-12-05 11:31:06', '2025-12-05 11:31:06'),
(52, 5, 16, 1.000, 'pz', NULL, '2025-12-05 11:31:30', '2025-12-05 11:31:30'),
(53, 5, 17, 1.000, 'pz', NULL, '2025-12-05 11:31:42', '2025-12-05 11:31:42'),
(54, 5, 37, 1.000, 'pz', NULL, '2025-12-05 11:32:13', '2025-12-05 11:32:13'),
(55, 5, 38, 1.000, 'pz', NULL, '2025-12-05 11:32:22', '2025-12-05 11:32:22'),
(56, 5, 45, 1.000, 'pz', NULL, '2025-12-05 11:32:29', '2025-12-05 11:32:29'),
(57, 1, 47, 1.000, 'pz', NULL, '2025-12-05 11:49:15', '2025-12-05 11:49:15'),
(58, 7, 48, 10.000, 'pz', NULL, '2025-12-09 08:10:51', '2025-12-09 08:10:51'),
(59, 8, 28, 1.000, 'pz', NULL, '2025-12-09 09:15:29', '2025-12-09 09:15:29'),
(60, 8, 1, 1.000, 'pz', NULL, '2025-12-09 09:17:36', '2025-12-09 09:17:36'),
(61, 8, 23, 1.000, 'pz', NULL, '2025-12-09 09:17:41', '2025-12-09 09:17:41'),
(62, 8, 36, 1.000, 'pz', NULL, '2025-12-09 09:17:58', '2025-12-09 09:17:58'),
(63, 8, 22, 1.000, 'pz', NULL, '2025-12-09 09:18:12', '2025-12-09 09:18:12'),
(64, 8, 2, 1.000, 'pz', NULL, '2025-12-09 09:18:55', '2025-12-09 09:18:55');

-- =============================================
-- Struttura tabella `failed_jobs`
-- =============================================

DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `job_batches`
-- =============================================

DROP TABLE IF EXISTS `job_batches`;
CREATE TABLE `job_batches` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `jobs`
-- =============================================

DROP TABLE IF EXISTS `jobs`;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `magazzino`
-- =============================================

DROP TABLE IF EXISTS `magazzino`;
CREATE TABLE `magazzino` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `prodotto_finito_id` bigint unsigned NOT NULL,
  `qta_disponibile` decimal(10,2) NOT NULL DEFAULT '0.00',
  `qta_impegnata` decimal(10,2) NOT NULL DEFAULT '0.00',
  `data_ultima_operazione` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `magazzino_prodotto_finito_id_foreign` (`prodotto_finito_id`),
  CONSTRAINT `magazzino_prodotto_finito_id_foreign` FOREIGN KEY (`prodotto_finito_id`) REFERENCES `prodotti_finiti` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `magazzino` (5 righe)

INSERT INTO `magazzino` (`id`, `prodotto_finito_id`, `qta_disponibile`, `qta_impegnata`, `data_ultima_operazione`, `created_at`, `updated_at`) VALUES
(1, 1, 300.00, 209.00, '2025-12-02 12:20:19', '2025-12-01 11:04:37', '2025-12-02 12:20:19'),
(2, 2, 30.00, 22.00, '2025-12-02 12:20:06', '2025-12-01 11:04:37', '2025-12-02 12:20:06'),
(3, 3, 120.00, 0.00, '2025-12-01 11:04:37', '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(4, 4, 200.00, 0.00, '2025-12-01 11:04:37', '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(5, 5, 50.00, 0.00, '2025-12-01 11:04:37', '2025-12-01 11:04:37', '2025-12-01 11:04:37');

-- =============================================
-- Struttura tabella `magazzino_materie_prime`
-- =============================================

DROP TABLE IF EXISTS `magazzino_materie_prime`;
CREATE TABLE `magazzino_materie_prime` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `materia_prima_id` bigint unsigned NOT NULL,
  `qta_disponibile` decimal(10,2) NOT NULL DEFAULT '0.00',
  `qta_impegnata` decimal(10,2) NOT NULL DEFAULT '0.00',
  `data_ultima_operazione` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `magazzino_materie_prime_materia_prima_id_foreign` (`materia_prima_id`),
  CONSTRAINT `magazzino_materie_prime_materia_prima_id_foreign` FOREIGN KEY (`materia_prima_id`) REFERENCES `materie_prime` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `magazzino_materie_prime` (48 righe)

INSERT INTO `magazzino_materie_prime` (`id`, `materia_prima_id`, `qta_disponibile`, `qta_impegnata`, `data_ultima_operazione`, `created_at`, `updated_at`) VALUES
(1, 1, 1000.00, 0.00, '2025-12-04 10:15:47', '2025-12-01 11:04:37', '2025-12-04 10:15:47'),
(2, 2, 10.00, 0.00, '2025-12-02 12:09:27', '2025-12-02 12:09:27', '2025-12-02 12:09:27'),
(3, 4, 97.00, 0.00, '2025-12-03 09:51:13', '2025-12-03 09:51:13', '2025-12-03 09:51:13'),
(5, 6, 16.00, 0.00, '2025-12-10 13:11:22', '2025-12-03 15:14:45', '2025-12-10 13:11:22'),
(6, 11, 10.00, 0.00, '2025-12-03 15:17:09', '2025-12-03 15:17:09', '2025-12-03 15:17:09'),
(7, 8, 202.00, 0.00, '2025-12-03 15:17:40', '2025-12-03 15:17:40', '2025-12-03 15:17:40'),
(8, 20, 2.00, 0.00, '2025-12-03 15:19:04', '2025-12-03 15:19:04', '2025-12-03 15:19:04'),
(9, 5, 150.00, 0.00, '2025-12-10 09:47:31', '2025-12-03 15:20:53', '2025-12-10 09:47:31'),
(10, 22, 2.00, 0.00, '2025-12-03 15:21:12', '2025-12-03 15:21:12', '2025-12-03 15:21:12'),
(11, 23, 2.00, 0.00, '2025-12-03 15:21:42', '2025-12-03 15:21:42', '2025-12-03 15:21:42'),
(12, 21, 2.00, 0.00, '2025-12-03 15:21:50', '2025-12-03 15:21:50', '2025-12-03 15:21:50'),
(13, 16, 96.00, 0.00, '2025-12-10 13:14:42', '2025-12-03 15:23:00', '2025-12-10 13:14:42'),
(14, 18, 199.00, 0.00, '2025-12-03 15:23:16', '2025-12-03 15:23:16', '2025-12-03 15:23:16'),
(15, 14, 97.00, 0.00, '2025-12-10 13:14:42', '2025-12-03 15:24:12', '2025-12-10 13:14:42'),
(16, 13, 210.00, 0.00, '2025-12-03 15:24:45', '2025-12-03 15:24:45', '2025-12-03 15:24:45'),
(17, 7, 10.00, 0.00, '2025-12-03 15:25:30', '2025-12-03 15:25:30', '2025-12-03 15:25:30'),
(18, 24, 92.00, 0.00, '2025-12-05 08:15:30', '2025-12-05 08:15:30', '2025-12-05 08:15:30'),
(19, 10, 10.00, 0.00, '2025-12-05 08:15:58', '2025-12-05 08:15:58', '2025-12-05 08:15:58'),
(20, 33, 252.00, 0.00, '2025-12-05 08:20:14', '2025-12-05 08:20:14', '2025-12-05 08:20:14'),
(21, 27, 218.00, 0.00, '2025-12-09 15:04:10', '2025-12-05 08:24:34', '2025-12-09 15:04:10'),
(22, 1, 9.00, 0.00, '2025-12-05 08:26:01', '2025-12-05 08:26:01', '2025-12-05 08:26:01'),
(23, 34, 200.00, 0.00, '2025-12-05 08:30:50', '2025-12-05 08:30:50', '2025-12-05 08:30:50'),
(24, 12, 220.00, 0.00, '2025-12-05 08:33:05', '2025-12-05 08:33:05', '2025-12-05 08:33:05'),
(25, 37, 1999.00, 0.00, '2025-12-10 13:14:42', '2025-12-05 08:34:48', '2025-12-10 13:14:42'),
(26, 38, 999.00, 0.00, '2025-12-10 13:14:42', '2025-12-05 08:35:10', '2025-12-10 13:14:42'),
(27, 39, 1000.00, 0.00, '2025-12-05 08:35:27', '2025-12-05 08:35:27', '2025-12-05 08:35:27'),
(28, 17, 93.00, 0.00, '2025-12-10 13:14:42', '2025-12-05 08:36:39', '2025-12-10 13:14:42'),
(29, 19, 112.00, 0.00, '2025-12-05 08:36:52', '2025-12-05 08:36:52', '2025-12-05 08:36:52'),
(30, 35, 8.00, 0.00, '2025-12-05 08:37:36', '2025-12-05 08:37:36', '2025-12-05 08:37:36'),
(31, 36, 123.00, 0.00, '2025-12-05 08:38:34', '2025-12-05 08:38:34', '2025-12-05 08:38:34'),
(32, 29, 72.00, 0.00, '2025-12-05 08:39:03', '2025-12-05 08:39:03', '2025-12-05 08:39:03'),
(33, 30, 119.00, 0.00, '2025-12-05 08:39:22', '2025-12-05 08:39:22', '2025-12-05 08:39:22'),
(34, 31, 776.00, 0.00, '2025-12-09 15:06:02', '2025-12-05 08:39:46', '2025-12-09 15:06:02'),
(35, 26, 38.00, 0.00, '2025-12-05 08:40:44', '2025-12-05 08:40:44', '2025-12-05 08:40:44'),
(36, 32, 220.00, 0.00, '2025-12-05 08:41:20', '2025-12-05 08:41:20', '2025-12-05 08:41:20'),
(37, 25, 16.00, 0.00, '2025-12-05 08:42:07', '2025-12-05 08:42:07', '2025-12-05 08:42:07'),
(38, 28, 18.00, 0.00, '2025-12-05 08:44:14', '2025-12-05 08:44:14', '2025-12-05 08:44:14'),
(39, 42, 30.00, 0.00, '2025-12-05 08:50:11', '2025-12-05 08:50:11', '2025-12-05 08:50:11'),
(40, 40, 97.00, 0.00, '2025-12-05 09:10:57', '2025-12-05 09:10:57', '2025-12-05 09:10:57'),
(41, 43, 4999.00, 0.00, '2025-12-10 13:14:42', '2025-12-05 11:24:09', '2025-12-10 13:14:42'),
(42, 44, 5000.00, 0.00, '2025-12-05 11:24:21', '2025-12-05 11:24:21', '2025-12-05 11:24:21'),
(43, 45, 1000.00, 0.00, '2025-12-05 11:24:45', '2025-12-05 11:24:45', '2025-12-05 11:24:45'),
(44, 47, 25.00, 0.00, '2025-12-05 11:48:52', '2025-12-05 11:48:52', '2025-12-05 11:48:52'),
(45, 15, 209.00, 0.00, '2025-12-10 13:14:42', '2025-12-09 09:49:39', '2025-12-10 13:14:42'),
(46, 50, 6.00, 0.00, '2025-12-09 10:34:20', '2025-12-09 10:34:20', '2025-12-09 10:34:20'),
(47, 49, 6.00, 0.00, '2025-12-09 10:34:33', '2025-12-09 10:34:33', '2025-12-09 10:34:33'),
(48, 51, 10.00, 0.00, '2025-12-09 15:09:32', '2025-12-09 15:09:32', '2025-12-09 15:09:32'),
(53, 3, 300.00, 0.00, '2025-12-10 13:19:38', '2025-12-10 13:19:38', '2025-12-10 13:19:38');

-- =============================================
-- Struttura tabella `materia_prima_documents`
-- =============================================

DROP TABLE IF EXISTS `materia_prima_documents`;
CREATE TABLE `materia_prima_documents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `materia_prima_id` bigint unsigned NOT NULL,
  `nome` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tipo di documento: modello_3d, datasheet, altro',
  `file_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_size` bigint unsigned DEFAULT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `materia_prima_documents_materia_prima_id_foreign` (`materia_prima_id`),
  CONSTRAINT `materia_prima_documents_materia_prima_id_foreign` FOREIGN KEY (`materia_prima_id`) REFERENCES `materie_prime` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `materie_prime`
-- =============================================

DROP TABLE IF EXISTS `materie_prime`;
CREATE TABLE `materie_prime` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codice` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titolo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `caratteristiche` text COLLATE utf8mb4_unicode_ci,
  `barcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qrcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unita_misura_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `materie_prime_codice_unique` (`codice`),
  UNIQUE KEY `materie_prime_barcode_unique` (`barcode`),
  UNIQUE KEY `materie_prime_qrcode_unique` (`qrcode`),
  KEY `materie_prime_unita_misura_id_foreign` (`unita_misura_id`),
  CONSTRAINT `materie_prime_unita_misura_id_foreign` FOREIGN KEY (`unita_misura_id`) REFERENCES `unita_di_misura` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `materie_prime` (49 righe)

INSERT INTO `materie_prime` (`id`, `codice`, `titolo`, `descrizione`, `caratteristiche`, `barcode`, `qrcode`, `unita_misura_id`, `created_at`, `updated_at`) VALUES
(1, 'MP-SPR-001', 'Molla', 'Molla di contatto (Negative pole)', 11, 8051234567890, 'MP-BAT-001-QR', NULL, '2025-12-01 11:04:37', '2025-12-02 11:53:57'),
(2, 'MP-CP-002', 'Clip +', 'Clip di contatto (Pole positive)', NULL, NULL, NULL, NULL, '2025-12-02 12:08:05', '2025-12-02 12:08:49'),
(3, 'PCB-SCP-UP', 'PCB S-Charger Plus', 'PCB Superiore', NULL, NULL, NULL, NULL, '2025-12-02 12:21:12', '2025-12-02 12:21:12'),
(4, 'MP-SPR-002', 'Contatto +', 'Contatto positivo degli slot delle pile', NULL, NULL, NULL, NULL, '2025-12-03 09:44:04', '2025-12-03 09:44:04'),
(5, 'MS-3D-000', 'Base usb c', 'stampa 3d', NULL, NULL, NULL, NULL, '2025-12-03 13:50:17', '2025-12-03 13:51:39'),
(6, 'MS-3D-001', 'Adattatore scheda', NULL, NULL, NULL, NULL, NULL, '2025-12-03 13:54:58', '2025-12-03 13:54:58'),
(7, 'MS-3D-002', 'Tappo intermedio', 'stampa 3d', NULL, NULL, NULL, NULL, '2025-12-03 13:57:03', '2025-12-03 13:57:03'),
(8, 'MS-3D-003', 'Base linguetta', 'stampa 3d', NULL, NULL, NULL, NULL, '2025-12-03 14:02:51', '2025-12-03 14:02:51'),
(10, 'MS-3D-005', 'Tappo superiore', 'stampa 3d', NULL, NULL, NULL, NULL, '2025-12-03 14:09:06', '2025-12-03 14:09:06'),
(11, 'MS-3D-006', 'Base case', 'stampa 3d', NULL, NULL, NULL, NULL, '2025-12-03 14:24:05', '2025-12-03 14:24:05'),
(12, 'MS-3D-007', 'ISOLANTE AAA -', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:25:47', '2025-12-03 14:25:47'),
(13, 'MS-3D-008', 'ISOLANTE AAA+', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:27:50', '2025-12-03 14:27:50'),
(14, 'MS-3D-009', 'ISOLANTE AA -', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:29:19', '2025-12-03 14:29:19'),
(15, 'MS-3D-010', 'ISOLANTE AA +', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:32:30', '2025-12-09 09:47:04'),
(16, 'MS-3D-012', 'CORPO AA', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:33:48', '2025-12-03 14:33:48'),
(17, 'MS-3D-013', 'TESTA AA', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:34:45', '2025-12-03 14:34:45'),
(18, 'MS-3D-014', 'CORPO AAA', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:35:44', '2025-12-03 14:35:44'),
(19, 'MS-3D-015', 'TESTA AAA', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:36:48', '2025-12-03 14:36:48'),
(20, 'MS-3D-016', 'BASE M CHARGER', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:38:47', '2025-12-03 14:38:47'),
(21, 'MS-3D-017', 'Coperchio M-CHARGER Station', NULL, NULL, NULL, NULL, NULL, '2025-12-03 14:44:42', '2025-12-04 10:14:48'),
(22, 'MS-3D-018', 'Case Superiore CAPTERMETER', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 15:11:00', '2025-12-04 10:14:04'),
(23, 'MS-3D-019', 'Chiusura CAPTERMETER', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 15:12:04', '2025-12-04 10:14:21'),
(24, 'CE-MP-000', 'LED BLU', 'COMPONENTE', NULL, NULL, NULL, NULL, '2025-12-04 13:34:14', '2025-12-04 13:34:14'),
(25, 'CE-MP-001', 'LED ARANCIONE', 'COMPONENTE', NULL, NULL, NULL, NULL, '2025-12-04 13:36:49', '2025-12-04 13:37:29'),
(26, 'CE-MP-002', 'DRIVER DC-DC', NULL, NULL, NULL, NULL, NULL, '2025-12-04 13:39:13', '2025-12-04 13:39:13'),
(27, 'CE-MP-003', 'LINGUETTA', NULL, NULL, NULL, NULL, NULL, '2025-12-04 13:40:23', '2025-12-04 13:40:23'),
(28, 'CE-MP-004', 'VOLTMETRO', NULL, NULL, NULL, NULL, NULL, '2025-12-04 13:42:39', '2025-12-04 13:42:39'),
(29, 'CE-MP-005', 'SUPER K S-CHARGER', NULL, NULL, NULL, NULL, NULL, '2025-12-04 13:44:07', '2025-12-04 13:44:07'),
(30, 'CE-MP-006', 'SUPER K PILA AA', NULL, NULL, NULL, NULL, NULL, '2025-12-04 13:45:12', '2025-12-04 13:45:12'),
(31, 'CE-MP-007', 'SUPER K PILA AAA', NULL, NULL, NULL, NULL, NULL, '2025-12-04 13:49:32', '2025-12-04 13:49:32'),
(32, 'CE-MP-008', 'VITI M 3X10', NULL, NULL, NULL, NULL, NULL, '2025-12-04 14:02:54', '2025-12-04 14:02:54'),
(33, 'CE-MP-009', 'INSERTO FILETTATO M3', NULL, NULL, NULL, NULL, NULL, '2025-12-04 14:04:49', '2025-12-04 14:04:49'),
(34, 'CE-MP-010', 'Packaging', 'CILINDRO DI CARTONE', NULL, NULL, NULL, NULL, '2025-12-04 14:07:30', '2025-12-04 14:07:30'),
(35, 'CE-MP-011', 'CONNETTORE ALIMENTATORE', NULL, NULL, NULL, NULL, NULL, '2025-12-04 14:08:51', '2025-12-04 14:08:51'),
(36, 'MS-3D-004', 'PULSANTE', NULL, NULL, NULL, NULL, NULL, '2025-12-04 14:12:51', '2025-12-04 14:13:24'),
(37, 'CE-MP-012', 'POLO + AA/AAA', NULL, NULL, NULL, NULL, NULL, '2025-12-04 15:48:30', '2025-12-04 15:48:30'),
(38, 'CE-MP-013', 'POLO - AA', NULL, NULL, NULL, NULL, NULL, '2025-12-04 15:49:20', '2025-12-04 15:49:20'),
(39, 'CE-MP-014', 'POLO - AAA', NULL, NULL, NULL, NULL, NULL, '2025-12-04 16:02:53', '2025-12-04 16:02:53'),
(40, 'CE-MP-015', 'PIASTRA BATTERIE+', NULL, NULL, NULL, NULL, NULL, '2025-12-05 08:45:53', '2025-12-05 08:45:53'),
(41, 'CE-MP-016', 'SCHEDA USB-C', NULL, NULL, NULL, NULL, NULL, '2025-12-05 08:47:20', '2025-12-05 08:47:20'),
(42, 'CE-MP-017', 'PCB - M-CHARGER', NULL, NULL, NULL, NULL, NULL, '2025-12-05 08:49:34', '2025-12-05 08:49:34'),
(43, 'ET-CP-000', 'ETICHETTA AA', NULL, NULL, NULL, NULL, NULL, '2025-12-05 11:18:29', '2025-12-05 11:18:29'),
(44, 'ET-CP-001', 'ETICHETTA AAA', NULL, NULL, NULL, NULL, NULL, '2025-12-05 11:19:02', '2025-12-05 11:19:02'),
(45, 'ET-CP-002', 'ETICHETTA BRIDGE', NULL, NULL, NULL, NULL, NULL, '2025-12-05 11:19:35', '2025-12-05 11:19:35'),
(47, 'CE-MP-018', 'VITE M4X6', NULL, NULL, NULL, NULL, NULL, '2025-12-05 11:47:56', '2025-12-05 11:47:56'),
(48, 'CE-MP-019', 'ADATTATORE AAA/AA', NULL, NULL, NULL, NULL, NULL, '2025-12-09 08:10:17', '2025-12-09 08:10:17'),
(49, 'MS-3D-020', 'ADATTATORE PILA 4P', NULL, NULL, NULL, NULL, NULL, '2025-12-09 10:30:44', '2025-12-09 10:30:44'),
(50, 'MS-3D-021', 'ADATTATORE PILA 2P', NULL, NULL, NULL, NULL, NULL, '2025-12-09 10:31:32', '2025-12-09 10:31:32'),
(51, 'CE-MP-020', 'CONTATTO 9V', NULL, NULL, NULL, NULL, NULL, '2025-12-09 15:08:53', '2025-12-09 15:08:53');

-- =============================================
-- Struttura tabella `migrations`
-- =============================================

DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `migrations` (32 righe)

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '0001_01_01_000000_create_users_table', 1),
(2, '0001_01_01_000001_create_cache_table', 1),
(3, '0001_01_01_000002_create_jobs_table', 1),
(4, '2025_11_21_091934_create_roles_table', 1),
(5, '2025_11_21_091935_create_permissions_table', 1),
(6, '2025_11_21_091936_create_permission_role_table', 1),
(7, '2025_11_21_091936_create_role_user_table', 1),
(8, '2025_11_21_092044_create_articles_table', 1),
(9, '2025_11_21_092047_create_article_documents_table', 1),
(10, '2025_11_21_095113_add_tipo_to_articles_table', 1),
(11, '2025_11_21_100848_create_materie_prime_table', 1),
(12, '2025_11_21_100848_create_prodotti_finiti_table', 1),
(13, '2025_11_21_100849_create_magazzino_materie_prime_table', 1),
(14, '2025_11_21_100850_create_magazzino_table', 1),
(15, '2025_11_21_100851_create_distinta_base_table', 1),
(16, '2025_11_21_135319_add_caratteristiche_to_prodotti_finiti_table', 1),
(17, '2025_11_21_135320_add_caratteristiche_to_materie_prime_table', 1),
(18, '2025_11_21_135320_create_prodotto_finito_documents_table', 1),
(19, '2025_11_21_135321_create_materia_prima_documents_table', 1),
(20, '2025_11_21_151104_create_article_distinta_base_table', 1),
(21, '2025_11_21_160424_create_clients_table', 1),
(22, '2025_11_21_160424_create_orders_table', 1),
(23, '2025_11_21_160425_create_order_items_table', 1),
(24, '2025_11_21_160426_create_payments_table', 1),
(25, '2025_11_22_023308_create_aliquote_iva_table', 1),
(26, '2025_11_22_023311_add_aliquota_iva_id_to_prodotti_finiti_table', 1),
(27, '2025_11_22_032812_add_foto_to_prodotti_finiti_table', 1),
(28, '2025_11_22_034639_update_orders_stato_enum', 1),
(29, '2025_11_22_042109_fix_distinta_base_table_structure', 1),
(30, '2025_11_22_042303_create_telescope_entries_table', 1),
(31, '2025_11_22_162908_create_unita_di_misura_table', 1),
(32, '2025_11_22_162919_add_unita_misura_id_to_articles_prodotti_finiti_materie_prime_tables', 1);

-- =============================================
-- Struttura tabella `order_items`
-- =============================================

DROP TABLE IF EXISTS `order_items`;
CREATE TABLE `order_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `prodotto_finito_id` bigint unsigned DEFAULT NULL,
  `article_id` bigint unsigned DEFAULT NULL,
  `quantita` int NOT NULL,
  `prezzo_unitario` decimal(10,2) NOT NULL,
  `sconto_percentuale` decimal(5,2) NOT NULL DEFAULT '0.00',
  `sconto_importo` decimal(10,2) NOT NULL DEFAULT '0.00',
  `totale_riga` decimal(10,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_items_order_id_foreign` (`order_id`),
  KEY `order_items_prodotto_finito_id_foreign` (`prodotto_finito_id`),
  KEY `order_items_article_id_foreign` (`article_id`),
  CONSTRAINT `order_items_article_id_foreign` FOREIGN KEY (`article_id`) REFERENCES `articles` (`id`) ON DELETE RESTRICT,
  CONSTRAINT `order_items_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `order_items_prodotto_finito_id_foreign` FOREIGN KEY (`prodotto_finito_id`) REFERENCES `prodotti_finiti` (`id`) ON DELETE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `order_items` (7 righe)

INSERT INTO `order_items` (`id`, `order_id`, `prodotto_finito_id`, `article_id`, `quantita`, `prezzo_unitario`, `sconto_percentuale`, `sconto_importo`, `totale_riga`, `note`, `created_at`, `updated_at`) VALUES
(9, 7, 6, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-05 17:40:44', '2025-12-05 17:40:44'),
(10, 7, 4, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-05 17:40:44', '2025-12-05 17:40:44'),
(11, 7, 3, NULL, 3, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-05 17:40:44', '2025-12-05 17:40:44'),
(12, 7, 5, NULL, 3, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-05 17:40:44', '2025-12-05 17:40:44'),
(13, 7, 7, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-05 17:40:44', '2025-12-05 17:40:44'),
(14, 7, NULL, 4, 1, 157.00, 0.00, 0.00, 157.00, NULL, '2025-12-05 17:40:44', '2025-12-05 17:40:44'),
(18, 11, 3, NULL, 1, 16.00, 0.00, 0.00, 16.00, NULL, '2025-12-10 13:14:27', '2025-12-10 13:14:27');

-- =============================================
-- Struttura tabella `orders`
-- =============================================

DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `numero_ordine` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `data_ordine` date NOT NULL,
  `data_consegna` date DEFAULT NULL,
  `sconto_percentuale` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Sconto in percentuale',
  `sconto_importo` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'Sconto in importo fisso',
  `totale` decimal(10,2) NOT NULL DEFAULT '0.00',
  `stato` enum('in_ordine','in_lavorazione','sospeso','in_attesa_materiali','completato','in_spedizione','consegnato') COLLATE utf8mb4_unicode_ci DEFAULT 'in_ordine',
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `orders_numero_ordine_unique` (`numero_ordine`),
  KEY `orders_client_id_foreign` (`client_id`),
  KEY `orders_user_id_foreign` (`user_id`),
  CONSTRAINT `orders_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`) ON DELETE RESTRICT,
  CONSTRAINT `orders_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `orders` (2 righe)

INSERT INTO `orders` (`id`, `numero_ordine`, `client_id`, `user_id`, `data_ordine`, `data_consegna`, `sconto_percentuale`, `sconto_importo`, `totale`, `stato`, `note`, `created_at`, `updated_at`) VALUES
(7, 'ORD-2025-000002', 5, NULL, '2025-12-05', '2026-01-31', 0.00, 0.00, 157.00, 'in_ordine', NULL, '2025-12-05 17:40:44', '2025-12-05 17:40:44'),
(11, 'ORD-2025-000003', 3, NULL, '2025-12-10', NULL, 0.00, 0.00, 16.00, 'completato', NULL, '2025-12-10 13:14:27', '2025-12-10 13:14:42');

-- =============================================
-- Struttura tabella `password_reset_tokens`
-- =============================================

DROP TABLE IF EXISTS `password_reset_tokens`;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `payments`
-- =============================================

DROP TABLE IF EXISTS `payments`;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `importo` decimal(10,2) NOT NULL,
  `data_pagamento` date NOT NULL,
  `metodo_pagamento` enum('contanti','bonifico','carta','assegno','altro') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'contanti',
  `stato` enum('in_attesa','completato','rifiutato') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'in_attesa',
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payments_order_id_foreign` (`order_id`),
  CONSTRAINT `payments_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `permission_role`
-- =============================================

DROP TABLE IF EXISTS `permission_role`;
CREATE TABLE `permission_role` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permission_role_permission_id_role_id_unique` (`permission_id`,`role_id`),
  KEY `permission_role_role_id_foreign` (`role_id`),
  CONSTRAINT `permission_role_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `permission_role_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `permission_role` (20 righe)

INSERT INTO `permission_role` (`id`, `permission_id`, `role_id`, `created_at`, `updated_at`) VALUES
(1, 1, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(2, 2, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(3, 3, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(4, 4, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(5, 5, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(6, 6, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(7, 7, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(8, 8, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(9, 9, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(10, 10, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(11, 11, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(12, 12, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(13, 13, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(14, 14, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(15, 12, 2, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(16, 14, 2, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(17, 13, 2, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(18, 11, 2, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(19, 1, 2, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(20, 11, 3, '2025-12-01 11:04:37', '2025-12-01 11:04:37');

-- =============================================
-- Struttura tabella `permissions`
-- =============================================

DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_unique` (`name`),
  UNIQUE KEY `permissions_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `permissions` (14 righe)

INSERT INTO `permissions` (`id`, `name`, `slug`, `description`, `group`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Visualizzare Utenti', 'users.view', 'Permette di visualizzare la lista degli utenti', 'users', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(2, 'Creare Utenti', 'users.create', 'Permette di creare nuovi utenti', 'users', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(3, 'Modificare Utenti', 'users.edit', 'Permette di modificare gli utenti esistenti', 'users', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(4, 'Eliminare Utenti', 'users.delete', 'Permette di eliminare gli utenti', 'users', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(5, 'Visualizzare Ruoli', 'roles.view', 'Permette di visualizzare la lista dei ruoli', 'roles', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(6, 'Creare Ruoli', 'roles.create', 'Permette di creare nuovi ruoli', 'roles', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(7, 'Modificare Ruoli', 'roles.edit', 'Permette di modificare i ruoli esistenti', 'roles', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(8, 'Eliminare Ruoli', 'roles.delete', 'Permette di eliminare i ruoli', 'roles', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(9, 'Visualizzare Permessi', 'permissions.view', 'Permette di visualizzare la lista dei permessi', 'permissions', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(10, 'Gestire Permessi', 'permissions.manage', 'Permette di gestire i permessi', 'permissions', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(11, 'Visualizzare Prodotti', 'products.view', 'Permette di visualizzare i prodotti', 'products', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(12, 'Creare Prodotti', 'products.create', 'Permette di creare nuovi prodotti', 'products', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(13, 'Modificare Prodotti', 'products.edit', 'Permette di modificare i prodotti', 'products', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(14, 'Eliminare Prodotti', 'products.delete', 'Permette di eliminare i prodotti', 'products', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37');

-- =============================================
-- Struttura tabella `prodotti_finiti`
-- =============================================

DROP TABLE IF EXISTS `prodotti_finiti`;
CREATE TABLE `prodotti_finiti` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codice` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titolo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `caratteristiche` text COLLATE utf8mb4_unicode_ci,
  `barcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qrcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unita_misura_id` bigint unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `aliquota_iva_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `prodotti_finiti_codice_unique` (`codice`),
  UNIQUE KEY `prodotti_finiti_barcode_unique` (`barcode`),
  UNIQUE KEY `prodotti_finiti_qrcode_unique` (`qrcode`),
  KEY `prodotti_finiti_aliquota_iva_id_foreign` (`aliquota_iva_id`),
  KEY `prodotti_finiti_unita_misura_id_foreign` (`unita_misura_id`),
  CONSTRAINT `prodotti_finiti_aliquota_iva_id_foreign` FOREIGN KEY (`aliquota_iva_id`) REFERENCES `aliquote_iva` (`id`) ON DELETE SET NULL,
  CONSTRAINT `prodotti_finiti_unita_misura_id_foreign` FOREIGN KEY (`unita_misura_id`) REFERENCES `unita_di_misura` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `prodotti_finiti` (8 righe)

INSERT INTO `prodotti_finiti` (`id`, `codice`, `titolo`, `descrizione`, `caratteristiche`, `barcode`, `qrcode`, `unita_misura_id`, `foto`, `aliquota_iva_id`, `created_at`, `updated_at`) VALUES
(1, 'PF-SCP-001', 'S-Charger Plus', 'Caricatore Portatile', NULL, 'PF-SCP-001-OIDUPB', 'PF-SCP-001-OIDSMN', NULL, 'prodotti_finiti_foto/TSa7l6M0OjTQNGzARxG9IY9H6jATwgZn4YGfyLio.png', NULL, '2025-12-01 11:04:37', '2025-12-02 11:43:09'),
(2, 'PF-MCS-002', 'M-Charger Station', 'Caricatore Desktop', NULL, 8051234567892, 'PF-MCS-002-OJ2HMM', NULL, 'prodotti_finiti_foto/UWrax8d3ptYS5SfXou9RM050XfnyWnRfF4oGjeas.png', NULL, '2025-12-01 11:04:37', '2025-12-02 12:01:57'),
(3, 'PF-BAT-003', 'AA Captery ULTRA', NULL, NULL, 8051234567893, 'PF-BAT-003-QR', NULL, 'prodotti_finiti_foto/dAxOcRrboAdMWOfmlDrec8dLLDHoRNN2DrFdBZdy.png', NULL, '2025-12-01 11:04:37', '2025-12-04 13:44:20'),
(4, 'PF-BAT-004', 'AAA Captery ULTRA', NULL, NULL, 8051234567894, 'PF-BAT-004-QR', NULL, 'prodotti_finiti_foto/W9tdj9V51TcJC2uMhWcLJ99tAFaNRzxu1DJeIzFc.png', NULL, '2025-12-01 11:04:37', '2025-12-04 13:45:37'),
(5, 'PF-BAT-005', 'AA Captery Bridge', NULL, NULL, 8051234567895, 'PF-BAT-005-QR', NULL, 'prodotti_finiti_foto/lMtAucF4X7tE8Z2dpXvf96Sj4Ol9cPPgl6Oil6DZ.png', NULL, '2025-12-01 11:04:37', '2025-12-04 13:46:20'),
(6, 'PF-BAT-006', 'AAA Captery Bridge', NULL, NULL, NULL, NULL, NULL, 'prodotti_finiti_foto/V5ya4OMg0jNXUBkOm9KCNW75BlUkUymGwiAwKQQW.png', NULL, '2025-12-02 12:05:10', '2025-12-04 15:22:54'),
(7, 'PF-BAT-007', 'Adattatore AAA/AA', NULL, NULL, NULL, NULL, NULL, 'prodotti_finiti_foto/2TxQCdUSnUsPgTsrSkizK0q3OL33FEOsvO0b7gCN.png', NULL, '2025-12-04 13:28:48', '2025-12-04 13:28:48'),
(8, 'PF-CPM-001', 'CapterMeter', NULL, NULL, NULL, NULL, NULL, 'prodotti_finiti_foto/QFiau42a80XqsxXZyaNzfthClrbiL4d2CipN86Kb.png', NULL, '2025-12-05 17:45:39', '2025-12-09 09:24:45');

-- =============================================
-- Struttura tabella `prodotto_finito_documents`
-- =============================================

DROP TABLE IF EXISTS `prodotto_finito_documents`;
CREATE TABLE `prodotto_finito_documents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `prodotto_finito_id` bigint unsigned NOT NULL,
  `nome` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tipo di documento: modello_3d, datasheet, altro',
  `file_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_size` bigint unsigned DEFAULT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `prodotto_finito_documents_prodotto_finito_id_foreign` (`prodotto_finito_id`),
  CONSTRAINT `prodotto_finito_documents_prodotto_finito_id_foreign` FOREIGN KEY (`prodotto_finito_id`) REFERENCES `prodotti_finiti` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `role_user`
-- =============================================

DROP TABLE IF EXISTS `role_user`;
CREATE TABLE `role_user` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role_user_user_id_role_id_unique` (`user_id`,`role_id`),
  KEY `role_user_role_id_foreign` (`role_id`),
  CONSTRAINT `role_user_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `role_user` (2 righe)

INSERT INTO `role_user` (`id`, `user_id`, `role_id`, `created_at`, `updated_at`) VALUES
(1, 1, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(2, 2, 2, '2025-12-01 11:04:37', '2025-12-01 11:04:37');

-- =============================================
-- Struttura tabella `roles`
-- =============================================

DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_unique` (`name`),
  UNIQUE KEY `roles_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `roles` (3 righe)

INSERT INTO `roles` (`id`, `name`, `slug`, `description`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Amministratore', 'admin', 'Ruolo con tutti i permessi', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(2, 'Manager', 'manager', 'Ruolo per la gestione operativa', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(3, 'Utente', 'user', 'Ruolo base per gli utenti', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37');

-- =============================================
-- Struttura tabella `sessions`
-- =============================================

DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `unita_di_misura`
-- =============================================

DROP TABLE IF EXISTS `unita_di_misura`;
CREATE TABLE `unita_di_misura` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codice` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `simbolo` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `attiva` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unita_di_misura_codice_unique` (`codice`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `users`
-- =============================================

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `users` (2 righe)

INSERT INTO `users` (`id`, `name`, `email`, `email_verified_at`, `password`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, 'Amministratore', 'admin@example.com', '2025-12-01 11:04:37', '$2y$12$mi6cYufLBR4d4L1O4i7OnuLDGNxNhdgvm/74LM3iViKqU296LKmdG', NULL, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(2, 'Manager', 'manager@example.com', '2025-12-01 11:04:37', '$2y$12$iCt7Gd.RHRJfgyk4jih8JOPeApqu4knH9lpKtWpD2UYJt9ZeQHOOi', NULL, '2025-12-01 11:04:37', '2025-12-01 11:04:37');

SET FOREIGN_KEY_CHECKS=1;
COMMIT;
