-- =============================================
-- Backup del Database: am
-- Data: 2026-01-23 11:54:20
-- Generato da: Laravel Backup Module
-- =============================================

SET FOREIGN_KEY_CHECKS=0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

-- =============================================
-- Struttura tabella `aliquote_iva`
-- =============================================

DROP TABLE IF EXISTS `aliquote_iva`;
CREATE TABLE `aliquote_iva` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codice` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `percentuale` decimal(5,2) NOT NULL,
  `descrizione` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attiva` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `aliquote_iva_codice_unique` (`codice`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `aliquote_iva` (5 righe)

INSERT INTO `aliquote_iva` (`id`, `codice`, `percentuale`, `descrizione`, `attiva`, `created_at`, `updated_at`) VALUES
(1, 'IVA22', 22.00, 'Aliquota ordinaria - 22%', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(2, 'IVA10', 10.00, 'Aliquota ridotta - 10%', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(3, 'IVA5', 5.00, 'Aliquota super ridotta - 5%', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(4, 'IVA4', 4.00, 'Aliquota minima - 4%', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(5, 'IVA0', 0.00, 'Esente - 0%', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37');

-- =============================================
-- Struttura tabella `article_distinta_base`
-- =============================================

DROP TABLE IF EXISTS `article_distinta_base`;
CREATE TABLE `article_distinta_base` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `article_id` bigint unsigned NOT NULL,
  `prodotto_finito_id` bigint unsigned NOT NULL,
  `quantita` decimal(10,3) NOT NULL DEFAULT '1.000',
  `unita_misura` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pz',
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `article_distinta_base_article_id_prodotto_finito_id_unique` (`article_id`,`prodotto_finito_id`),
  KEY `article_distinta_base_prodotto_finito_id_foreign` (`prodotto_finito_id`),
  CONSTRAINT `article_distinta_base_article_id_foreign` FOREIGN KEY (`article_id`) REFERENCES `articles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `article_distinta_base_prodotto_finito_id_foreign` FOREIGN KEY (`prodotto_finito_id`) REFERENCES `prodotti_finiti` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `article_distinta_base` (34 righe)

INSERT INTO `article_distinta_base` (`id`, `article_id`, `prodotto_finito_id`, `quantita`, `unita_misura`, `note`, `created_at`, `updated_at`) VALUES
(1, 1, 6, 1.000, 'pz', NULL, '2025-12-02 12:26:09', '2025-12-02 12:26:09'),
(2, 1, 1, 1.000, 'pz', NULL, '2025-12-02 12:26:09', '2025-12-02 12:26:09'),
(3, 1, 4, 1.000, 'pz', NULL, '2025-12-02 12:26:09', '2025-12-02 12:26:09'),
(4, 2, 1, 1.000, 'pz', NULL, '2025-12-02 12:27:04', '2025-12-02 12:27:04'),
(5, 2, 3, 1.000, 'pz', NULL, '2025-12-02 12:27:04', '2025-12-02 12:27:04'),
(6, 2, 5, 1.000, 'pz', NULL, '2025-12-02 12:27:04', '2025-12-02 12:27:04'),
(7, 3, 6, 1.000, 'pz', NULL, '2025-12-02 12:30:24', '2025-12-02 12:30:24'),
(8, 3, 1, 1.000, 'pz', NULL, '2025-12-02 12:30:24', '2025-12-02 12:30:24'),
(9, 3, 3, 1.000, 'pz', NULL, '2025-12-02 12:30:24', '2025-12-02 12:30:24'),
(10, 3, 4, 1.000, 'pz', NULL, '2025-12-02 12:30:24', '2025-12-02 12:30:24'),
(11, 3, 5, 1.000, 'pz', NULL, '2025-12-02 12:30:24', '2025-12-02 12:30:24'),
(12, 4, 6, 2.000, 'pz', NULL, '2025-12-02 12:33:27', '2025-12-02 12:33:27'),
(13, 4, 1, 1.000, 'pz', NULL, '2025-12-02 12:33:27', '2025-12-02 12:33:27'),
(14, 4, 3, 2.000, 'pz', NULL, '2025-12-02 12:33:27', '2025-12-02 12:33:27'),
(15, 4, 4, 2.000, 'pz', NULL, '2025-12-02 12:33:27', '2025-12-02 12:33:27'),
(16, 4, 5, 2.000, 'pz', NULL, '2025-12-02 12:33:27', '2025-12-02 12:33:27'),
(22, 5, 6, 4.000, 'pz', NULL, '2025-12-04 11:15:14', '2025-12-04 11:15:14'),
(23, 5, 1, 2.000, 'pz', NULL, '2025-12-04 11:15:14', '2025-12-04 11:15:14'),
(24, 5, 3, 4.000, 'pz', NULL, '2025-12-04 11:15:14', '2025-12-04 11:15:14'),
(25, 5, 4, 4.000, 'pz', NULL, '2025-12-04 11:15:14', '2025-12-04 11:15:14'),
(26, 5, 5, 4.000, 'pz', NULL, '2025-12-04 11:15:14', '2025-12-04 11:15:14'),
(27, 6, 2, 1.000, 'pz', NULL, '2025-12-04 11:16:57', '2025-12-04 11:16:57'),
(28, 6, 3, 10.000, 'pz', NULL, '2025-12-04 11:16:57', '2025-12-04 11:16:57'),
(29, 6, 5, 10.000, 'pz', NULL, '2025-12-04 11:16:57', '2025-12-04 11:16:57'),
(30, 7, 6, 10.000, 'pz', NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(31, 7, 1, 1.000, 'pz', NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(32, 7, 2, 1.000, 'pz', NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(33, 7, 3, 10.000, 'pz', NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(34, 7, 4, 10.000, 'pz', NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(35, 7, 5, 10.000, 'pz', NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(36, 8, 6, 2.000, 'pz', NULL, '2025-12-05 11:08:17', '2025-12-05 11:08:17'),
(37, 8, 4, 2.000, 'pz', NULL, '2025-12-05 11:08:17', '2025-12-05 11:08:17'),
(38, 9, 3, 2.000, 'pz', NULL, '2025-12-05 11:09:12', '2025-12-05 11:09:12'),
(39, 9, 5, 2.000, 'pz', NULL, '2025-12-05 11:09:12', '2025-12-05 11:09:12');

-- =============================================
-- Struttura tabella `article_documents`
-- =============================================

DROP TABLE IF EXISTS `article_documents`;
CREATE TABLE `article_documents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `article_id` bigint unsigned NOT NULL,
  `nome` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tipo di documento: modello_3d, datasheet, altro',
  `file_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_size` bigint unsigned DEFAULT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `article_documents_article_id_foreign` (`article_id`),
  CONSTRAINT `article_documents_article_id_foreign` FOREIGN KEY (`article_id`) REFERENCES `articles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `articles`
-- =============================================

DROP TABLE IF EXISTS `articles`;
CREATE TABLE `articles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codice` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` enum('materia_prima','semilavorato','prodotto_finito') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'materia_prima',
  `titolo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `barcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qrcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unita_misura_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `articles_codice_unique` (`codice`),
  UNIQUE KEY `articles_barcode_unique` (`barcode`),
  UNIQUE KEY `articles_qrcode_unique` (`qrcode`),
  KEY `articles_unita_misura_id_foreign` (`unita_misura_id`),
  CONSTRAINT `articles_unita_misura_id_foreign` FOREIGN KEY (`unita_misura_id`) REFERENCES `unita_di_misura` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `articles` (9 righe)

INSERT INTO `articles` (`id`, `codice`, `tipo`, `titolo`, `descrizione`, `barcode`, `qrcode`, `unita_misura_id`, `created_at`, `updated_at`) VALUES
(1, 'KIT-001', 'prodotto_finito', 'BASIC AAA ULTRA KIT', 'S-Charger Plus + AAA Captery + AAA CapteryBridge', NULL, NULL, NULL, '2025-12-02 12:26:09', '2025-12-02 12:26:09'),
(2, 'KIT-002', 'prodotto_finito', 'BASIC AA ULTRA KIT', 'S-Charger Plus + AA Captery + AA CapteryBridge', NULL, NULL, NULL, '2025-12-02 12:27:04', '2025-12-02 12:27:04'),
(3, 'KIT-003', 'prodotto_finito', 'Standard ULTRA KIT', 'S-Charger Plus + AA Captery+ AAACaptery+ AACapteryBridge + AAACapteryridge', NULL, NULL, NULL, '2025-12-02 12:30:24', '2025-12-02 12:30:24'),
(4, 'KIT-004', 'prodotto_finito', 'SUPREME ULTRA KIT', 'S-Charger Plus + 2 x CapteryAA + 2 x CapteryAAA + 2 x CapteryBridgeAA + 2 x CapteryridgeAAA', NULL, NULL, NULL, '2025-12-02 12:33:27', '2025-12-02 12:33:27'),
(5, 'KIT-005', 'prodotto_finito', 'DELUXE ULTRA KIT', 'S-Charger Plus + 4 x CapteryAA + 4 x CapteryAAA + 4 x CapteryBridgeAA + 4 x CapteryridgeAAA', NULL, NULL, NULL, '2025-12-04 11:02:54', '2025-12-04 11:15:14'),
(6, 'KIT-006', 'prodotto_finito', 'M-Charger Station Kit', 'M-Charger Station + 10x AA Captery ULTRA + 10xAA Captery Bridge', NULL, NULL, NULL, '2025-12-04 11:16:57', '2025-12-04 11:16:57'),
(7, 'KIT-007', 'prodotto_finito', 'Diamond Kit - Limited Edition', 'S-Charger Plus + M-Charger Station + CapterMeter + 10xAA Captery Ultra + 10xAA Captery Bridge+ 10xAAA Captery Ultra + 10xAAA Captery Bridge + 10xAdaptors.', NULL, NULL, NULL, '2025-12-04 11:22:27', '2025-12-04 11:22:27'),
(8, 'Kit-008', 'prodotto_finito', 'Captery AAA ULTRA KIT', '2xCaptery AAA + 2xCaptery Bridge AAA', NULL, NULL, NULL, '2025-12-05 11:08:17', '2025-12-05 11:08:17'),
(9, 'KIT-009', 'prodotto_finito', 'Captery AA ULTRA KIT', '2 x CapteryAA ULTRA + 2x Captery Bridge AA', NULL, NULL, NULL, '2025-12-05 11:09:12', '2025-12-05 11:09:12');

-- =============================================
-- Struttura tabella `cache`
-- =============================================

DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `cache_locks`
-- =============================================

DROP TABLE IF EXISTS `cache_locks`;
CREATE TABLE `cache_locks` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `clients`
-- =============================================

DROP TABLE IF EXISTS `clients`;
CREATE TABLE `clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nome` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `indirizzo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `citta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cap` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `provincia` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `partita_iva` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codice_fiscale` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `clients_nome_index` (`nome`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `clients` (46 righe)

INSERT INTO `clients` (`id`, `nome`, `email`, `telefono`, `indirizzo`, `citta`, `cap`, `provincia`, `partita_iva`, `codice_fiscale`, `note`, `created_at`, `updated_at`) VALUES
(1, 'Kickstarter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-02 13:01:20', '2025-12-02 13:01:20'),
(2, 'Wide Solution', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-03 11:32:09', '2025-12-03 11:32:09'),
(3, 'Rithema', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-05 10:57:02', '2025-12-05 10:57:02'),
(4, 'Massimiliano Censi', 'massimiliano.censi90@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-05 14:40:21', '2025-12-05 14:40:21'),
(5, 'DS', 'sprocket_man_@hotmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-05 17:37:42', '2025-12-05 17:37:42'),
(6, 'Kickstarter Italia', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:08:14', '2025-12-12 14:08:14'),
(7, 'Massimiliano Censi', 'massimiliano.censi90@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:12:14', '2025-12-12 14:12:14'),
(8, 'Giusy Coppola', 'giusy.cop4@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:15:09', '2025-12-12 14:15:09'),
(9, 'Gavino Ignazio', 'uleri.1988@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:15:55', '2025-12-12 14:15:55'),
(10, 'Tomas Acquistapace', 't.acquistapace@lumenwatt.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:17:06', '2025-12-12 14:17:06'),
(11, 'Alfredo Spinapolice', 'al.spin@icloud.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:18:19', '2025-12-12 14:18:19'),
(12, 'Alex D\'Elia', 'acmesh@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:19:17', '2025-12-12 14:19:17'),
(13, 'Gilda', 'gilda.avena@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:20:47', '2025-12-12 14:20:47'),
(14, 'Alessandro Saetta', 'alesae@hotmail.it', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:22:26', '2025-12-12 14:22:26'),
(15, 'Lorenzo', 'tom.lorenzo77@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:23:33', '2025-12-12 14:23:33'),
(16, 'Sergio Perero', 'sergio.perero@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:25:32', '2025-12-12 14:25:32'),
(17, 'Lorenzo Baiocco', 'lore.baiocco@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:26:18', '2025-12-12 14:26:18'),
(18, 'Antonio Molinari', 'antoniomolinari@me.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:27:16', '2025-12-12 14:27:16'),
(19, 'Etneo Italia', 'energia@etneo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:28:23', '2025-12-12 14:28:23'),
(20, 'Andrea Mulloni', 'andrea.mulloni@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:29:19', '2025-12-12 14:29:19'),
(21, 'Valerio Emili', 'valerioemili@tutanota.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:30:40', '2025-12-12 14:30:40'),
(22, 'Hoang Huynh', 'hoangchau.huynh@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:32:44', '2025-12-12 14:32:44'),
(23, 'Paolo Leonardi', 'klfp@interfree.it', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:33:49', '2025-12-12 14:33:49'),
(24, 'Annalisa Pepe', 'pepe.lisa@libero.it', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:34:45', '2025-12-12 14:34:45'),
(25, 'Giada Pianigiani', 'gipi_92@hotmail.it', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:35:38', '2025-12-12 14:35:38'),
(26, 'Michelangelo Smeriglio', 'romeomgc@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:36:32', '2025-12-12 14:36:32'),
(27, 'Valerio', 'valerioal@yahoo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:37:30', '2025-12-12 14:37:30'),
(28, 'Roberto Piccoli', 'rporpo@hotmail.it', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:38:47', '2025-12-12 14:38:47'),
(29, 'Marco Filipas', 'marcofilipas@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:39:41', '2025-12-12 14:39:41'),
(30, 'Leonardo Del Nonno', 'ldelnonno@yahoo.it', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:40:37', '2025-12-12 14:40:37'),
(31, 'Francesco Callini', 'francescocallini@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 14:47:26', '2025-12-12 14:47:26'),
(32, 'Carla Spadonaro', 'c.spandonaro@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:19:13', '2025-12-12 16:19:13'),
(33, 'Aldo Perasso', 'aldo.perasso@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:20:15', '2025-12-12 16:20:15'),
(34, 'Anna', 'annarella82_@hotmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:21:54', '2025-12-12 16:21:54'),
(35, 'Marta Basso', 'martabassof@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:33:19', '2025-12-12 16:33:19'),
(36, 'Carlo Matera', 'carlomate@tiscali.it', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:41:53', '2025-12-12 16:41:53'),
(37, 'Resolve', 'resolveid@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:42:41', '2025-12-12 16:42:41'),
(38, 'Enrica', 'e@ongarienrica.it', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:43:24', '2025-12-12 16:43:24'),
(39, 'Felice', 'felice.felice@libero.it', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:44:10', '2025-12-12 16:44:10'),
(40, 'Claudio Coco', 'lacocio@libero.it', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:45:11', '2025-12-12 16:45:11'),
(41, 'Ciungiu', 'm.campora@icloud.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:46:15', '2025-12-12 16:46:15'),
(42, 'Daniela Oddi', 'daniela.oddi@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:47:06', '2025-12-12 16:47:06'),
(43, 'Paolo', 'paspao@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:47:57', '2025-12-12 16:47:57'),
(44, 'Cristoforo Senatore', 'avvocatosenatore@libero.it', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:48:34', '2025-12-12 16:48:34'),
(45, 'Giovanni Coppola', 'gioncop@libero.it', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:49:21', '2025-12-12 16:49:21'),
(46, 'Vito Andrea Campobasso', 'hunlish85@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-12-12 16:50:21', '2025-12-12 16:50:21');

-- =============================================
-- Struttura tabella `distinta_base`
-- =============================================

DROP TABLE IF EXISTS `distinta_base`;
CREATE TABLE `distinta_base` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `prodotto_finito_id` bigint unsigned NOT NULL,
  `materia_prima_id` bigint unsigned NOT NULL,
  `quantita` decimal(10,3) NOT NULL DEFAULT '1.000',
  `unita_misura` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pz',
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `distinta_base_prodotto_finito_id_materia_prima_id_unique` (`prodotto_finito_id`,`materia_prima_id`),
  KEY `distinta_base_materia_prima_id_foreign` (`materia_prima_id`),
  CONSTRAINT `distinta_base_materia_prima_id_foreign` FOREIGN KEY (`materia_prima_id`) REFERENCES `materie_prime` (`id`) ON DELETE CASCADE,
  CONSTRAINT `distinta_base_prodotto_finito_id_foreign` FOREIGN KEY (`prodotto_finito_id`) REFERENCES `prodotti_finiti` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `distinta_base` (59 righe)

INSERT INTO `distinta_base` (`id`, `prodotto_finito_id`, `materia_prima_id`, `quantita`, `unita_misura`, `note`, `created_at`, `updated_at`) VALUES
(6, 1, 2, 1.000, '1 pz', NULL, '2025-12-02 19:53:48', '2025-12-02 19:53:48'),
(7, 1, 1, 1.000, '1 pz', NULL, '2025-12-02 19:54:08', '2025-12-02 19:54:08'),
(8, 1, 3, 1.000, '1 pz', NULL, '2025-12-02 19:54:16', '2025-12-02 19:54:16'),
(9, 2, 1, 10.000, '10 pz', NULL, '2025-12-02 19:56:20', '2025-12-02 19:56:20'),
(10, 2, 4, 10.000, 10, NULL, '2025-12-03 09:51:56', '2025-12-03 09:51:56'),
(11, 1, 5, 1.000, '1 pz', NULL, '2025-12-04 16:34:41', '2025-12-04 16:34:41'),
(12, 1, 27, 1.000, '1 pz', NULL, '2025-12-04 16:35:03', '2025-12-04 16:35:03'),
(13, 1, 36, 1.000, '1 pz', NULL, '2025-12-04 16:35:21', '2025-12-04 16:35:21'),
(14, 1, 8, 1.000, '1 pz', NULL, '2025-12-04 16:35:29', '2025-12-04 16:35:29'),
(15, 1, 24, 1.000, '1 pz', NULL, '2025-12-04 16:36:08', '2025-12-04 16:36:08'),
(16, 1, 33, 1.000, '1 pz', NULL, '2025-12-04 16:36:20', '2025-12-04 16:36:20'),
(17, 1, 26, 1.000, '1 pz', NULL, '2025-12-04 16:36:31', '2025-12-04 16:36:31'),
(18, 1, 32, 1.000, '1 pz', NULL, '2025-12-04 16:36:49', '2025-12-04 16:36:49'),
(19, 1, 7, 1.000, '1 pz', NULL, '2025-12-04 16:36:57', '2025-12-04 16:36:57'),
(20, 1, 10, 1.000, '1 pz', NULL, '2025-12-04 16:37:12', '2025-12-04 16:37:12'),
(21, 1, 34, 1.000, '1 pz', NULL, '2025-12-04 16:37:53', '2025-12-04 16:37:53'),
(22, 1, 29, 1.000, '1 pz', NULL, '2025-12-04 16:38:11', '2025-12-04 16:38:11'),
(23, 2, 20, 1.000, '1 pz', NULL, '2025-12-04 16:47:43', '2025-12-04 16:47:43'),
(24, 2, 21, 1.000, '1 pz', NULL, '2025-12-04 16:47:59', '2025-12-04 16:47:59'),
(25, 1, 41, 1.000, 'pz', NULL, '2025-12-05 09:06:05', '2025-12-05 09:06:05'),
(26, 6, 18, 1.000, 'pz', NULL, '2025-12-05 09:13:17', '2025-12-05 09:13:17'),
(27, 6, 19, 1.000, 'pz', NULL, '2025-12-05 09:13:49', '2025-12-05 09:13:49'),
(28, 6, 37, 1.000, 'pz', NULL, '2025-12-05 09:15:48', '2025-12-05 09:15:48'),
(29, 6, 39, 1.000, 'pz', NULL, '2025-12-05 09:16:00', '2025-12-05 09:16:00'),
(30, 2, 42, 1.000, 'pz', NULL, '2025-12-05 11:07:29', '2025-12-05 11:07:29'),
(31, 2, 26, 1.000, 'pz', NULL, '2025-12-05 11:07:59', '2025-12-05 11:07:59'),
(32, 2, 25, 10.000, 'pz', NULL, '2025-12-05 11:09:25', '2025-12-05 11:09:25'),
(33, 2, 33, 6.000, 'pz', NULL, '2025-12-05 11:10:01', '2025-12-05 11:10:01'),
(34, 2, 35, 1.000, 'pz', NULL, '2025-12-05 11:10:24', '2025-12-05 11:10:24'),
(35, 2, 32, 6.000, 'pz', NULL, '2025-12-05 11:11:28', '2025-12-05 11:11:28'),
(36, 3, 16, 1.000, 'pz', NULL, '2025-12-05 11:12:22', '2025-12-05 11:12:22'),
(37, 3, 17, 1.000, 'pz', NULL, '2025-12-05 11:12:31', '2025-12-05 11:12:31'),
(38, 3, 15, 1.000, 'pz', NULL, '2025-12-05 11:12:49', '2025-12-05 11:12:49'),
(39, 3, 14, 1.000, 'pz', NULL, '2025-12-05 11:12:55', '2025-12-05 11:12:55'),
(40, 3, 37, 1.000, 'pz', NULL, '2025-12-05 11:13:16', '2025-12-05 11:13:16'),
(41, 3, 38, 1.000, 'pz', NULL, '2025-12-05 11:13:34', '2025-12-05 11:13:34'),
(42, 3, 43, 1.000, 'pz', NULL, '2025-12-05 11:26:07', '2025-12-05 11:26:07'),
(43, 4, 44, 1.000, 'pz', NULL, '2025-12-05 11:27:09', '2025-12-05 11:27:09'),
(44, 4, 18, 1.000, 'pz', NULL, '2025-12-05 11:27:19', '2025-12-05 11:27:19'),
(45, 4, 19, 1.000, 'pz', NULL, '2025-12-05 11:27:34', '2025-12-05 11:27:34'),
(46, 4, 37, 1.000, 'pz', NULL, '2025-12-05 11:28:04', '2025-12-05 11:28:04'),
(47, 4, 39, 1.000, 'pz', NULL, '2025-12-05 11:28:16', '2025-12-05 11:28:16'),
(48, 4, 31, 1.000, 'pz', NULL, '2025-12-05 11:29:14', '2025-12-05 11:29:14'),
(49, 4, 12, 1.000, 'pz', NULL, '2025-12-05 11:30:02', '2025-12-05 11:30:02'),
(50, 4, 13, 1.000, 'pz', NULL, '2025-12-05 11:30:16', '2025-12-05 11:30:16'),
(51, 6, 45, 1.000, 'pz', NULL, '2025-12-05 11:31:06', '2025-12-05 11:31:06'),
(52, 5, 16, 1.000, 'pz', NULL, '2025-12-05 11:31:30', '2025-12-05 11:31:30'),
(53, 5, 17, 1.000, 'pz', NULL, '2025-12-05 11:31:42', '2025-12-05 11:31:42'),
(54, 5, 37, 1.000, 'pz', NULL, '2025-12-05 11:32:13', '2025-12-05 11:32:13'),
(55, 5, 38, 1.000, 'pz', NULL, '2025-12-05 11:32:22', '2025-12-05 11:32:22'),
(56, 5, 45, 1.000, 'pz', NULL, '2025-12-05 11:32:29', '2025-12-05 11:32:29'),
(57, 1, 47, 1.000, 'pz', NULL, '2025-12-05 11:49:15', '2025-12-05 11:49:15'),
(58, 7, 48, 10.000, 'pz', NULL, '2025-12-09 08:10:51', '2025-12-09 08:10:51'),
(59, 8, 28, 1.000, 'pz', NULL, '2025-12-09 09:15:29', '2025-12-09 09:15:29'),
(60, 8, 1, 1.000, 'pz', NULL, '2025-12-09 09:17:36', '2025-12-09 09:17:36'),
(61, 8, 23, 1.000, 'pz', NULL, '2025-12-09 09:17:41', '2025-12-09 09:17:41'),
(62, 8, 36, 1.000, 'pz', NULL, '2025-12-09 09:17:58', '2025-12-09 09:17:58'),
(63, 8, 22, 1.000, 'pz', NULL, '2025-12-09 09:18:12', '2025-12-09 09:18:12'),
(64, 8, 2, 1.000, 'pz', NULL, '2025-12-09 09:18:55', '2025-12-09 09:18:55');

-- =============================================
-- Struttura tabella `failed_jobs`
-- =============================================

DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `job_batches`
-- =============================================

DROP TABLE IF EXISTS `job_batches`;
CREATE TABLE `job_batches` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `jobs`
-- =============================================

DROP TABLE IF EXISTS `jobs`;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `magazzino`
-- =============================================

DROP TABLE IF EXISTS `magazzino`;
CREATE TABLE `magazzino` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `prodotto_finito_id` bigint unsigned NOT NULL,
  `qta_disponibile` decimal(10,2) NOT NULL DEFAULT '0.00',
  `qta_impegnata` decimal(10,2) NOT NULL DEFAULT '0.00',
  `data_ultima_operazione` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `magazzino_prodotto_finito_id_foreign` (`prodotto_finito_id`),
  CONSTRAINT `magazzino_prodotto_finito_id_foreign` FOREIGN KEY (`prodotto_finito_id`) REFERENCES `prodotti_finiti` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `magazzino` (6 righe)

INSERT INTO `magazzino` (`id`, `prodotto_finito_id`, `qta_disponibile`, `qta_impegnata`, `data_ultima_operazione`, `created_at`, `updated_at`) VALUES
(1, 1, 300.00, 209.00, '2025-12-02 12:20:19', '2025-12-01 11:04:37', '2025-12-02 12:20:19'),
(2, 2, 30.00, 22.00, '2025-12-02 12:20:06', '2025-12-01 11:04:37', '2025-12-02 12:20:06'),
(3, 3, 120.00, 0.00, '2025-12-01 11:04:37', '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(4, 4, 200.00, 0.00, '2025-12-01 11:04:37', '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(5, 5, 50.00, 0.00, '2025-12-01 11:04:37', '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(6, 8, 20.00, 0.00, '2025-12-12 17:01:30', '2025-12-12 17:01:30', '2025-12-12 17:01:30');

-- =============================================
-- Struttura tabella `magazzino_materie_prime`
-- =============================================

DROP TABLE IF EXISTS `magazzino_materie_prime`;
CREATE TABLE `magazzino_materie_prime` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `materia_prima_id` bigint unsigned NOT NULL,
  `qta_disponibile` decimal(10,2) NOT NULL DEFAULT '0.00',
  `qta_impegnata` decimal(10,2) NOT NULL DEFAULT '0.00',
  `data_ultima_operazione` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `magazzino_materie_prime_materia_prima_id_foreign` (`materia_prima_id`),
  CONSTRAINT `magazzino_materie_prime_materia_prima_id_foreign` FOREIGN KEY (`materia_prima_id`) REFERENCES `materie_prime` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `magazzino_materie_prime` (50 righe)

INSERT INTO `magazzino_materie_prime` (`id`, `materia_prima_id`, `qta_disponibile`, `qta_impegnata`, `data_ultima_operazione`, `created_at`, `updated_at`) VALUES
(1, 1, 999.00, 1.00, '2025-12-12 16:52:40', '2025-12-01 11:04:37', '2025-12-12 16:52:40'),
(2, 2, 9.00, 1.00, '2025-12-12 16:52:40', '2025-12-02 12:09:27', '2025-12-12 16:52:40'),
(3, 4, 97.00, 0.00, '2025-12-03 09:51:13', '2025-12-03 09:51:13', '2025-12-03 09:51:13'),
(5, 6, 20.00, 0.00, '2025-12-16 14:28:37', '2025-12-03 15:14:45', '2025-12-16 14:28:37'),
(6, 11, 30.00, 0.00, '2025-12-15 12:15:50', '2025-12-03 15:17:09', '2025-12-15 12:15:50'),
(7, 8, 201.00, 1.00, '2025-12-12 16:52:40', '2025-12-03 15:17:40', '2025-12-12 16:52:40'),
(8, 20, 2.00, 0.00, '2025-12-03 15:19:04', '2025-12-03 15:19:04', '2025-12-03 15:19:04'),
(9, 5, 149.00, 1.00, '2025-12-12 16:52:40', '2025-12-03 15:20:53', '2025-12-12 16:52:40'),
(10, 22, 22.00, 0.00, '2025-12-15 12:17:06', '2025-12-03 15:21:12', '2025-12-15 12:17:06'),
(11, 23, 22.00, 0.00, '2025-12-15 12:17:53', '2025-12-03 15:21:42', '2025-12-15 12:17:53'),
(12, 21, 2.00, 0.00, '2025-12-03 15:21:50', '2025-12-03 15:21:50', '2025-12-03 15:21:50'),
(13, 16, 85.00, 2.00, '2025-12-12 16:52:40', '2025-12-03 15:23:00', '2025-12-12 16:52:40'),
(14, 18, 191.00, 6.00, '2025-12-12 16:52:40', '2025-12-03 15:23:16', '2025-12-12 16:52:40'),
(15, 14, 91.00, 1.00, '2025-12-12 16:52:40', '2025-12-03 15:24:12', '2025-12-12 16:52:40'),
(16, 13, 206.00, 3.00, '2025-12-12 16:52:40', '2025-12-03 15:24:45', '2025-12-12 16:52:40'),
(17, 7, 30.00, 1.00, '2025-12-15 12:18:45', '2025-12-03 15:25:30', '2025-12-15 12:18:45'),
(18, 24, 91.00, 1.00, '2025-12-12 16:52:40', '2025-12-05 08:15:30', '2025-12-12 16:52:40'),
(19, 10, 29.00, 1.00, '2025-12-15 12:16:25', '2025-12-05 08:15:58', '2025-12-15 12:16:25'),
(20, 33, 251.00, 1.00, '2025-12-12 16:52:40', '2025-12-05 08:20:14', '2025-12-12 16:52:40'),
(21, 27, 217.00, 1.00, '2025-12-12 16:52:40', '2025-12-05 08:24:34', '2025-12-12 16:52:40'),
(22, 1, 9.00, 0.00, '2025-12-05 08:26:01', '2025-12-05 08:26:01', '2025-12-05 08:26:01'),
(23, 34, 199.00, 1.00, '2025-12-12 16:52:40', '2025-12-05 08:30:50', '2025-12-12 16:52:40'),
(24, 12, 216.00, 3.00, '2025-12-12 16:52:40', '2025-12-05 08:33:05', '2025-12-12 16:52:40'),
(25, 37, 1980.00, 8.00, '2025-12-12 16:52:40', '2025-12-05 08:34:48', '2025-12-12 16:52:40'),
(26, 38, 988.00, 2.00, '2025-12-12 16:52:40', '2025-12-05 08:35:10', '2025-12-12 16:52:40'),
(27, 39, 992.00, 6.00, '2025-12-12 16:52:40', '2025-12-05 08:35:27', '2025-12-12 16:52:40'),
(28, 17, 82.00, 2.00, '2025-12-12 16:52:40', '2025-12-05 08:36:39', '2025-12-12 16:52:40'),
(29, 19, 104.00, 6.00, '2025-12-12 16:52:40', '2025-12-05 08:36:52', '2025-12-12 16:52:40'),
(30, 35, 8.00, 0.00, '2025-12-05 08:37:36', '2025-12-05 08:37:36', '2025-12-05 08:37:36'),
(31, 36, 122.00, 1.00, '2025-12-12 16:52:40', '2025-12-05 08:38:34', '2025-12-12 16:52:40'),
(32, 29, 71.00, 1.00, '2025-12-12 16:52:40', '2025-12-05 08:39:03', '2025-12-12 16:52:40'),
(33, 30, 119.00, 0.00, '2025-12-05 08:39:22', '2025-12-05 08:39:22', '2025-12-05 08:39:22'),
(34, 31, 882.00, 3.00, '2025-12-12 16:52:40', '2025-12-05 08:39:46', '2025-12-12 16:52:40'),
(35, 26, 37.00, 1.00, '2025-12-12 16:52:40', '2025-12-05 08:40:44', '2025-12-12 16:52:40'),
(36, 32, 219.00, 1.00, '2025-12-12 16:52:40', '2025-12-05 08:41:20', '2025-12-12 16:52:40'),
(37, 25, 16.00, 0.00, '2025-12-05 08:42:07', '2025-12-05 08:42:07', '2025-12-05 08:42:07'),
(38, 28, 18.00, 8.00, '2025-12-18 15:51:30', '2025-12-05 08:44:14', '2025-12-18 15:51:30'),
(39, 42, 30.00, 0.00, '2025-12-05 08:50:11', '2025-12-05 08:50:11', '2025-12-05 08:50:11'),
(40, 40, 97.00, 0.00, '2025-12-05 09:10:57', '2025-12-05 09:10:57', '2025-12-05 09:10:57'),
(41, 43, 4993.00, 1.00, '2025-12-12 16:52:40', '2025-12-05 11:24:09', '2025-12-12 16:52:40'),
(42, 44, 4996.00, 3.00, '2025-12-12 16:52:40', '2025-12-05 11:24:21', '2025-12-12 16:52:40'),
(43, 45, 991.00, 4.00, '2025-12-12 16:52:40', '2025-12-05 11:24:45', '2025-12-12 16:52:40'),
(44, 47, 24.00, 1.00, '2025-12-12 16:52:40', '2025-12-05 11:48:52', '2025-12-12 16:52:40'),
(45, 15, 203.00, 1.00, '2025-12-12 16:52:40', '2025-12-09 09:49:39', '2025-12-12 16:52:40'),
(46, 50, 6.00, 0.00, '2025-12-09 10:34:20', '2025-12-09 10:34:20', '2025-12-09 10:34:20'),
(47, 49, 6.00, 0.00, '2025-12-09 10:34:33', '2025-12-09 10:34:33', '2025-12-09 10:34:33'),
(48, 51, 10.00, 0.00, '2025-12-09 15:09:32', '2025-12-09 15:09:32', '2025-12-09 15:09:32'),
(53, 3, 299.00, 1.00, '2025-12-12 16:52:40', '2025-12-10 13:19:38', '2025-12-12 16:52:40'),
(56, 48, 10.00, 0.00, '2025-12-15 13:42:53', '2025-12-11 21:49:28', '2025-12-15 13:42:53'),
(57, 41, 17.00, 1.00, '2025-12-15 13:41:08', '2025-12-11 21:49:28', '2025-12-15 13:41:08');

-- =============================================
-- Struttura tabella `materia_prima_documents`
-- =============================================

DROP TABLE IF EXISTS `materia_prima_documents`;
CREATE TABLE `materia_prima_documents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `materia_prima_id` bigint unsigned NOT NULL,
  `nome` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tipo di documento: modello_3d, datasheet, altro',
  `file_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_size` bigint unsigned DEFAULT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `materia_prima_documents_materia_prima_id_foreign` (`materia_prima_id`),
  CONSTRAINT `materia_prima_documents_materia_prima_id_foreign` FOREIGN KEY (`materia_prima_id`) REFERENCES `materie_prime` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `materie_prime`
-- =============================================

DROP TABLE IF EXISTS `materie_prime`;
CREATE TABLE `materie_prime` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codice` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titolo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `caratteristiche` text COLLATE utf8mb4_unicode_ci,
  `barcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qrcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unita_misura_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `materie_prime_codice_unique` (`codice`),
  UNIQUE KEY `materie_prime_barcode_unique` (`barcode`),
  UNIQUE KEY `materie_prime_qrcode_unique` (`qrcode`),
  KEY `materie_prime_unita_misura_id_foreign` (`unita_misura_id`),
  CONSTRAINT `materie_prime_unita_misura_id_foreign` FOREIGN KEY (`unita_misura_id`) REFERENCES `unita_di_misura` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `materie_prime` (49 righe)

INSERT INTO `materie_prime` (`id`, `codice`, `titolo`, `descrizione`, `caratteristiche`, `barcode`, `qrcode`, `unita_misura_id`, `created_at`, `updated_at`) VALUES
(1, 'MP-SPR-001', 'Molla', 'Molla di contatto (Negative pole)', 11, 8051234567890, 'MP-BAT-001-QR', NULL, '2025-12-01 11:04:37', '2025-12-02 11:53:57'),
(2, 'MP-CP-002', 'Clip +', 'Clip di contatto (Pole positive)', NULL, NULL, NULL, NULL, '2025-12-02 12:08:05', '2025-12-02 12:08:49'),
(3, 'PCB-SCP-UP', 'PCB S-Charger Plus', 'PCB Superiore', NULL, NULL, NULL, NULL, '2025-12-02 12:21:12', '2025-12-02 12:21:12'),
(4, 'MP-SPR-002', 'Contatto +', 'Contatto positivo degli slot delle pile', NULL, NULL, NULL, NULL, '2025-12-03 09:44:04', '2025-12-03 09:44:04'),
(5, 'MS-3D-000', 'Base usb c', 'stampa 3d', NULL, NULL, NULL, NULL, '2025-12-03 13:50:17', '2025-12-03 13:51:39'),
(6, 'MS-3D-001', 'Adattatore scheda', NULL, NULL, NULL, NULL, NULL, '2025-12-03 13:54:58', '2025-12-03 13:54:58'),
(7, 'MS-3D-002', 'Tappo intermedio', 'stampa 3d', NULL, NULL, NULL, NULL, '2025-12-03 13:57:03', '2025-12-03 13:57:03'),
(8, 'MS-3D-003', 'Base linguetta', 'stampa 3d', NULL, NULL, NULL, NULL, '2025-12-03 14:02:51', '2025-12-03 14:02:51'),
(10, 'MS-3D-005', 'Tappo superiore', 'stampa 3d', NULL, NULL, NULL, NULL, '2025-12-03 14:09:06', '2025-12-03 14:09:06'),
(11, 'MS-3D-006', 'Base case', 'stampa 3d', NULL, NULL, NULL, NULL, '2025-12-03 14:24:05', '2025-12-03 14:24:05'),
(12, 'MS-3D-007', 'ISOLANTE AAA -', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:25:47', '2025-12-03 14:25:47'),
(13, 'MS-3D-008', 'ISOLANTE AAA+', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:27:50', '2025-12-03 14:27:50'),
(14, 'MS-3D-009', 'ISOLANTE AA -', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:29:19', '2025-12-03 14:29:19'),
(15, 'MS-3D-010', 'ISOLANTE AA +', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:32:30', '2025-12-09 09:47:04'),
(16, 'MS-3D-012', 'CORPO AA', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:33:48', '2025-12-03 14:33:48'),
(17, 'MS-3D-013', 'TESTA AA', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:34:45', '2025-12-03 14:34:45'),
(18, 'MS-3D-014', 'CORPO AAA', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:35:44', '2025-12-03 14:35:44'),
(19, 'MS-3D-015', 'TESTA AAA', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:36:48', '2025-12-03 14:36:48'),
(20, 'MS-3D-016', 'BASE M CHARGER', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 14:38:47', '2025-12-03 14:38:47'),
(21, 'MS-3D-017', 'Coperchio M-CHARGER Station', NULL, NULL, NULL, NULL, NULL, '2025-12-03 14:44:42', '2025-12-04 10:14:48'),
(22, 'MS-3D-018', 'Case Superiore CAPTERMETER', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 15:11:00', '2025-12-04 10:14:04'),
(23, 'MS-3D-019', 'Chiusura CAPTERMETER', 'STAMPA 3D', NULL, NULL, NULL, NULL, '2025-12-03 15:12:04', '2025-12-04 10:14:21'),
(24, 'CE-MP-000', 'LED BLU', 'COMPONENTE', NULL, NULL, NULL, NULL, '2025-12-04 13:34:14', '2025-12-04 13:34:14'),
(25, 'CE-MP-001', 'LED ARANCIONE', 'COMPONENTE', NULL, NULL, NULL, NULL, '2025-12-04 13:36:49', '2025-12-04 13:37:29'),
(26, 'CE-MP-002', 'DRIVER DC-DC', NULL, NULL, NULL, NULL, NULL, '2025-12-04 13:39:13', '2025-12-04 13:39:13'),
(27, 'CE-MP-003', 'LINGUETTA', NULL, NULL, NULL, NULL, NULL, '2025-12-04 13:40:23', '2025-12-04 13:40:23'),
(28, 'CE-MP-004', 'VOLTMETRO', NULL, NULL, NULL, NULL, NULL, '2025-12-04 13:42:39', '2025-12-04 13:42:39'),
(29, 'CE-MP-005', 'SUPER K S-CHARGER', NULL, NULL, NULL, NULL, NULL, '2025-12-04 13:44:07', '2025-12-04 13:44:07'),
(30, 'CE-MP-006', 'SUPER K PILA AA', NULL, NULL, NULL, NULL, NULL, '2025-12-04 13:45:12', '2025-12-04 13:45:12'),
(31, 'CE-MP-007', 'SUPER K PILA AAA', NULL, NULL, NULL, NULL, NULL, '2025-12-04 13:49:32', '2025-12-04 13:49:32'),
(32, 'CE-MP-008', 'VITI M 3X10', NULL, NULL, NULL, NULL, NULL, '2025-12-04 14:02:54', '2025-12-04 14:02:54'),
(33, 'CE-MP-009', 'INSERTO FILETTATO M3', NULL, NULL, NULL, NULL, NULL, '2025-12-04 14:04:49', '2025-12-04 14:04:49'),
(34, 'CE-MP-010', 'Packaging', 'CILINDRO DI CARTONE', NULL, NULL, NULL, NULL, '2025-12-04 14:07:30', '2025-12-04 14:07:30'),
(35, 'CE-MP-011', 'CONNETTORE ALIMENTATORE', NULL, NULL, NULL, NULL, NULL, '2025-12-04 14:08:51', '2025-12-04 14:08:51'),
(36, 'MS-3D-004', 'PULSANTE', NULL, NULL, NULL, NULL, NULL, '2025-12-04 14:12:51', '2025-12-04 14:13:24'),
(37, 'CE-MP-012', 'POLO + AA/AAA', NULL, NULL, NULL, NULL, NULL, '2025-12-04 15:48:30', '2025-12-04 15:48:30'),
(38, 'CE-MP-013', 'POLO - AA', NULL, NULL, NULL, NULL, NULL, '2025-12-04 15:49:20', '2025-12-04 15:49:20'),
(39, 'CE-MP-014', 'POLO - AAA', NULL, NULL, NULL, NULL, NULL, '2025-12-04 16:02:53', '2025-12-04 16:02:53'),
(40, 'CE-MP-015', 'PIASTRA BATTERIE+', NULL, NULL, NULL, NULL, NULL, '2025-12-05 08:45:53', '2025-12-05 08:45:53'),
(41, 'CE-MP-016', 'SCHEDA USB-C', NULL, NULL, NULL, NULL, NULL, '2025-12-05 08:47:20', '2025-12-05 08:47:20'),
(42, 'CE-MP-017', 'PCB - M-CHARGER', NULL, NULL, NULL, NULL, NULL, '2025-12-05 08:49:34', '2025-12-05 08:49:34'),
(43, 'ET-CP-000', 'ETICHETTA AA', NULL, NULL, NULL, NULL, NULL, '2025-12-05 11:18:29', '2025-12-05 11:18:29'),
(44, 'ET-CP-001', 'ETICHETTA AAA', NULL, NULL, NULL, NULL, NULL, '2025-12-05 11:19:02', '2025-12-05 11:19:02'),
(45, 'ET-CP-002', 'ETICHETTA BRIDGE', NULL, NULL, NULL, NULL, NULL, '2025-12-05 11:19:35', '2025-12-05 11:19:35'),
(47, 'CE-MP-018', 'VITE M4X6', NULL, NULL, NULL, NULL, NULL, '2025-12-05 11:47:56', '2025-12-05 11:47:56'),
(48, 'CE-MP-019', 'ADATTATORE AAA/AA', NULL, NULL, NULL, NULL, NULL, '2025-12-09 08:10:17', '2025-12-09 08:10:17'),
(49, 'MS-3D-020', 'ADATTATORE PILA 4P', NULL, NULL, NULL, NULL, NULL, '2025-12-09 10:30:44', '2025-12-09 10:30:44'),
(50, 'MS-3D-021', 'ADATTATORE PILA 2P', NULL, NULL, NULL, NULL, NULL, '2025-12-09 10:31:32', '2025-12-09 10:31:32'),
(51, 'CE-MP-020', 'CONTATTO 9V', NULL, NULL, NULL, NULL, NULL, '2025-12-09 15:08:53', '2025-12-09 15:08:53');

-- =============================================
-- Struttura tabella `migrations`
-- =============================================

DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `migrations` (32 righe)

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '0001_01_01_000000_create_users_table', 1),
(2, '0001_01_01_000001_create_cache_table', 1),
(3, '0001_01_01_000002_create_jobs_table', 1),
(4, '2025_11_21_091934_create_roles_table', 1),
(5, '2025_11_21_091935_create_permissions_table', 1),
(6, '2025_11_21_091936_create_permission_role_table', 1),
(7, '2025_11_21_091936_create_role_user_table', 1),
(8, '2025_11_21_092044_create_articles_table', 1),
(9, '2025_11_21_092047_create_article_documents_table', 1),
(10, '2025_11_21_095113_add_tipo_to_articles_table', 1),
(11, '2025_11_21_100848_create_materie_prime_table', 1),
(12, '2025_11_21_100848_create_prodotti_finiti_table', 1),
(13, '2025_11_21_100849_create_magazzino_materie_prime_table', 1),
(14, '2025_11_21_100850_create_magazzino_table', 1),
(15, '2025_11_21_100851_create_distinta_base_table', 1),
(16, '2025_11_21_135319_add_caratteristiche_to_prodotti_finiti_table', 1),
(17, '2025_11_21_135320_add_caratteristiche_to_materie_prime_table', 1),
(18, '2025_11_21_135320_create_prodotto_finito_documents_table', 1),
(19, '2025_11_21_135321_create_materia_prima_documents_table', 1),
(20, '2025_11_21_151104_create_article_distinta_base_table', 1),
(21, '2025_11_21_160424_create_clients_table', 1),
(22, '2025_11_21_160424_create_orders_table', 1),
(23, '2025_11_21_160425_create_order_items_table', 1),
(24, '2025_11_21_160426_create_payments_table', 1),
(25, '2025_11_22_023308_create_aliquote_iva_table', 1),
(26, '2025_11_22_023311_add_aliquota_iva_id_to_prodotti_finiti_table', 1),
(27, '2025_11_22_032812_add_foto_to_prodotti_finiti_table', 1),
(28, '2025_11_22_034639_update_orders_stato_enum', 1),
(29, '2025_11_22_042109_fix_distinta_base_table_structure', 1),
(30, '2025_11_22_042303_create_telescope_entries_table', 1),
(31, '2025_11_22_162908_create_unita_di_misura_table', 1),
(32, '2025_11_22_162919_add_unita_misura_id_to_articles_prodotti_finiti_materie_prime_tables', 1);

-- =============================================
-- Struttura tabella `order_items`
-- =============================================

DROP TABLE IF EXISTS `order_items`;
CREATE TABLE `order_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `prodotto_finito_id` bigint unsigned DEFAULT NULL,
  `article_id` bigint unsigned DEFAULT NULL,
  `quantita` int NOT NULL,
  `prezzo_unitario` decimal(10,2) NOT NULL,
  `sconto_percentuale` decimal(5,2) NOT NULL DEFAULT '0.00',
  `sconto_importo` decimal(10,2) NOT NULL DEFAULT '0.00',
  `totale_riga` decimal(10,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_items_order_id_foreign` (`order_id`),
  KEY `order_items_prodotto_finito_id_foreign` (`prodotto_finito_id`),
  KEY `order_items_article_id_foreign` (`article_id`),
  CONSTRAINT `order_items_article_id_foreign` FOREIGN KEY (`article_id`) REFERENCES `articles` (`id`) ON DELETE RESTRICT,
  CONSTRAINT `order_items_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `order_items_prodotto_finito_id_foreign` FOREIGN KEY (`prodotto_finito_id`) REFERENCES `prodotti_finiti` (`id`) ON DELETE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `order_items` (64 righe)

INSERT INTO `order_items` (`id`, `order_id`, `prodotto_finito_id`, `article_id`, `quantita`, `prezzo_unitario`, `sconto_percentuale`, `sconto_importo`, `totale_riga`, `note`, `created_at`, `updated_at`) VALUES
(19, 12, 6, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:13:28', '2025-12-12 16:51:45'),
(20, 12, 4, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:13:28', '2025-12-12 16:51:45'),
(21, 12, NULL, 3, 1, 74.00, 0.00, 0.00, 74.00, NULL, '2025-12-12 14:13:28', '2025-12-12 16:51:45'),
(22, 13, NULL, 2, 1, 44.00, 0.00, 0.00, 44.00, NULL, '2025-12-12 14:15:30', '2025-12-12 14:15:30'),
(23, 14, 6, NULL, 1, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:16:37', '2025-12-12 14:16:37'),
(24, 14, NULL, 3, 1, 56.00, 0.00, 0.00, 56.00, NULL, '2025-12-12 14:16:37', '2025-12-12 14:16:37'),
(25, 15, NULL, 4, 1, 80.00, 0.00, 0.00, 80.00, NULL, '2025-12-12 14:17:39', '2025-12-12 14:17:39'),
(26, 16, NULL, 3, 1, 54.00, 0.00, 0.00, 54.00, NULL, '2025-12-12 14:18:51', '2025-12-12 14:18:51'),
(27, 17, 4, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:20:29', '2025-12-12 14:20:29'),
(28, 17, 3, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:20:29', '2025-12-12 14:20:29'),
(29, 17, NULL, 4, 1, 119.00, 0.00, 0.00, 119.00, NULL, '2025-12-12 14:20:29', '2025-12-12 14:20:29'),
(30, 18, 6, NULL, 1, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:21:51', '2025-12-12 14:21:51'),
(31, 18, 5, NULL, 1, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:21:51', '2025-12-12 14:21:51'),
(32, 18, NULL, 3, 1, 59.00, 0.00, 0.00, 59.00, NULL, '2025-12-12 14:21:51', '2025-12-12 14:21:51'),
(33, 19, NULL, 3, 1, 54.00, 0.00, 0.00, 54.00, NULL, '2025-12-12 14:22:50', '2025-12-12 14:22:50'),
(34, 20, 5, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:25:03', '2025-12-12 14:25:03'),
(35, 20, 3, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:25:03', '2025-12-12 14:25:03'),
(36, 20, 6, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:25:03', '2025-12-12 14:25:03'),
(37, 20, 4, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:25:03', '2025-12-12 14:25:03'),
(38, 20, NULL, 3, 1, 106.00, 0.00, 0.00, 106.00, NULL, '2025-12-12 14:25:03', '2025-12-12 14:25:03'),
(39, 21, NULL, 4, 1, 77.00, 0.00, 0.00, 77.00, NULL, '2025-12-12 14:25:54', '2025-12-12 16:52:02'),
(40, 22, NULL, 3, 1, 54.00, 0.00, 0.00, 54.00, NULL, '2025-12-12 14:26:50', '2025-12-12 14:26:50'),
(41, 23, NULL, 3, 1, 54.00, 0.00, 0.00, 54.00, NULL, '2025-12-12 14:27:35', '2025-12-12 14:27:35'),
(42, 24, NULL, 3, 1, 60.00, 0.00, 0.00, 60.00, NULL, '2025-12-12 14:28:48', '2025-12-12 14:28:48'),
(43, 25, NULL, 3, 1, 54.00, 0.00, 0.00, 54.00, NULL, '2025-12-12 14:30:00', '2025-12-12 14:30:00'),
(44, 26, NULL, 3, 1, 54.00, 0.00, 0.00, 54.00, NULL, '2025-12-12 14:31:59', '2025-12-12 14:31:59'),
(45, 27, NULL, 3, 1, 54.00, 0.00, 0.00, 54.00, NULL, '2025-12-12 14:33:05', '2025-12-12 14:33:05'),
(46, 28, 7, NULL, 4, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:34:28', '2025-12-12 14:34:28'),
(47, 28, NULL, 3, 1, 58.00, 0.00, 0.00, 58.00, NULL, '2025-12-12 14:34:28', '2025-12-12 14:34:28'),
(48, 29, NULL, 8, 1, 20.00, 0.00, 0.00, 20.00, NULL, '2025-12-12 14:35:13', '2025-12-12 14:35:13'),
(49, 30, NULL, 5, 1, 144.00, 0.00, 0.00, 144.00, NULL, '2025-12-12 14:36:01', '2025-12-12 14:36:01'),
(50, 31, 7, NULL, 1, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:37:06', '2025-12-12 14:37:06'),
(51, 31, NULL, 5, 1, 145.00, 0.00, 0.00, 145.00, NULL, '2025-12-12 14:37:06', '2025-12-12 14:37:06'),
(52, 32, NULL, 3, 1, 54.00, 0.00, 0.00, 54.00, NULL, '2025-12-12 14:37:50', '2025-12-12 14:37:50'),
(53, 33, 7, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:39:15', '2025-12-12 14:39:15'),
(54, 33, NULL, 3, 1, 56.00, 0.00, 0.00, 56.00, NULL, '2025-12-12 14:39:15', '2025-12-12 14:39:15'),
(55, 34, 7, NULL, 1, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:40:12', '2025-12-12 14:40:12'),
(56, 34, NULL, 3, 1, 55.00, 0.00, 0.00, 55.00, NULL, '2025-12-12 14:40:12', '2025-12-12 14:40:12'),
(57, 35, NULL, 4, 1, 77.00, 0.00, 0.00, 77.00, NULL, '2025-12-12 14:41:44', '2025-12-12 14:41:44'),
(58, 36, 7, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 14:48:01', '2025-12-12 14:48:01'),
(59, 36, NULL, 4, 1, 79.00, 0.00, 0.00, 79.00, NULL, '2025-12-12 14:48:01', '2025-12-12 14:48:01'),
(60, 37, 7, NULL, 1, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 16:19:52', '2025-12-12 16:19:52'),
(61, 37, NULL, 4, 1, 78.00, 0.00, 0.00, 78.00, NULL, '2025-12-12 16:19:52', '2025-12-12 16:19:52'),
(62, 38, 7, NULL, 1, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 16:21:33', '2025-12-12 16:21:33'),
(63, 38, NULL, 3, 1, 55.00, 0.00, 0.00, 55.00, NULL, '2025-12-12 16:21:33', '2025-12-12 16:21:33'),
(64, 39, NULL, 3, 1, 54.00, 0.00, 0.00, 54.00, NULL, '2025-12-12 16:22:39', '2025-12-12 16:22:39'),
(65, 40, 7, NULL, 1, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 16:34:20', '2025-12-12 16:34:20'),
(66, 40, NULL, 4, 1, 78.00, 0.00, 0.00, 78.00, NULL, '2025-12-12 16:34:20', '2025-12-12 16:34:20'),
(67, 41, NULL, 4, 1, 77.00, 0.00, 0.00, 77.00, NULL, '2025-12-12 16:42:19', '2025-12-12 16:42:19'),
(68, 42, NULL, 3, 1, 54.00, 0.00, 0.00, 54.00, NULL, '2025-12-12 16:42:56', '2025-12-12 16:42:56'),
(69, 43, NULL, 9, 1, 30.00, 0.00, 0.00, 30.00, NULL, '2025-12-12 16:43:56', '2025-12-12 16:43:56'),
(70, 44, NULL, 4, 1, 77.00, 0.00, 0.00, 77.00, NULL, '2025-12-12 16:44:51', '2025-12-12 16:44:51'),
(71, 45, 7, NULL, 2, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 16:45:55', '2025-12-12 16:45:55'),
(72, 45, NULL, 4, 1, 79.00, 0.00, 0.00, 79.00, NULL, '2025-12-12 16:45:55', '2025-12-12 16:45:55'),
(73, 46, NULL, 9, 1, 30.00, 0.00, 0.00, 30.00, NULL, '2025-12-12 16:46:44', '2025-12-12 16:46:44'),
(74, 47, 7, NULL, 1, 5.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 16:47:39', '2025-12-12 16:47:39'),
(75, 47, NULL, 3, 1, 55.00, 0.00, 0.00, 55.00, NULL, '2025-12-12 16:47:39', '2025-12-12 16:47:39'),
(76, 48, NULL, 3, 1, 54.00, 0.00, 0.00, 54.00, NULL, '2025-12-12 16:48:16', '2025-12-12 16:48:16'),
(77, 49, 7, NULL, 1, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 16:49:01', '2025-12-12 16:49:01'),
(78, 49, NULL, 4, 1, 78.00, 0.00, 0.00, 78.00, NULL, '2025-12-12 16:49:01', '2025-12-12 16:49:01'),
(79, 50, 7, NULL, 1, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 16:49:59', '2025-12-12 16:49:59'),
(80, 50, NULL, 2, 1, 45.00, 0.00, 0.00, 45.00, NULL, '2025-12-12 16:49:59', '2025-12-12 16:49:59'),
(81, 51, 7, NULL, 1, 1.00, 100.00, 0.00, 0.00, NULL, '2025-12-12 16:50:50', '2025-12-12 16:50:50'),
(82, 51, NULL, 4, 1, 78.00, 0.00, 0.00, 78.00, NULL, '2025-12-12 16:50:50', '2025-12-12 16:50:50');

-- =============================================
-- Struttura tabella `orders`
-- =============================================

DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `numero_ordine` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `data_ordine` date NOT NULL,
  `data_consegna` date DEFAULT NULL,
  `sconto_percentuale` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Sconto in percentuale',
  `sconto_importo` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'Sconto in importo fisso',
  `totale` decimal(10,2) NOT NULL DEFAULT '0.00',
  `stato` enum('in_ordine','in_lavorazione','sospeso','in_attesa_materiali','completato','in_spedizione','consegnato') COLLATE utf8mb4_unicode_ci DEFAULT 'in_ordine',
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `orders_numero_ordine_unique` (`numero_ordine`),
  KEY `orders_client_id_foreign` (`client_id`),
  KEY `orders_user_id_foreign` (`user_id`),
  CONSTRAINT `orders_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`) ON DELETE RESTRICT,
  CONSTRAINT `orders_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `orders` (40 righe)

INSERT INTO `orders` (`id`, `numero_ordine`, `client_id`, `user_id`, `data_ordine`, `data_consegna`, `sconto_percentuale`, `sconto_importo`, `totale`, `stato`, `note`, `created_at`, `updated_at`) VALUES
(12, 'ORD-2025-000001', 7, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 74.00, 'in_ordine', 'ITALIA', '2025-12-12 14:13:28', '2025-12-12 16:52:40'),
(13, 'ORD-2025-000002', 8, NULL, '2025-12-12', '2025-12-31', 0.00, 0.00, 44.00, 'in_ordine', 'ITALIA', '2025-12-12 14:15:30', '2025-12-12 14:15:30'),
(14, 'ORD-2025-000003', 9, NULL, '2025-12-12', '2025-12-31', 0.00, 0.00, 56.00, 'in_ordine', 'ITALIA', '2025-12-12 14:16:37', '2025-12-12 14:16:37'),
(15, 'ORD-2025-000004', 10, NULL, '2025-12-12', '2025-12-31', 0.00, 0.00, 80.00, 'in_ordine', 'ITALIA', '2025-12-12 14:17:39', '2025-12-12 14:17:39'),
(16, 'ORD-2025-000005', 11, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 54.00, 'in_ordine', NULL, '2025-12-12 14:18:51', '2025-12-12 14:18:51'),
(17, 'ORD-2025-000006', 12, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 119.00, 'in_ordine', NULL, '2025-12-12 14:20:29', '2025-12-12 14:20:29'),
(18, 'ORD-2025-000007', 13, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 59.00, 'in_ordine', NULL, '2025-12-12 14:21:51', '2025-12-12 14:21:51'),
(19, 'ORD-2025-000008', 14, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 54.00, 'in_ordine', NULL, '2025-12-12 14:22:50', '2025-12-12 14:22:50'),
(20, 'ORD-2025-000009', 15, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 106.00, 'in_ordine', NULL, '2025-12-12 14:25:03', '2025-12-12 14:25:03'),
(21, 'ORD-2025-000010', 16, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 77.00, 'in_ordine', NULL, '2025-12-12 14:25:54', '2025-12-12 16:52:02'),
(22, 'ORD-2025-000011', 17, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 54.00, 'in_ordine', NULL, '2025-12-12 14:26:50', '2025-12-12 14:26:50'),
(23, 'ORD-2025-000012', 18, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 54.00, 'in_ordine', NULL, '2025-12-12 14:27:35', '2025-12-12 14:27:35'),
(24, 'ORD-2025-000013', 19, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 60.00, 'in_ordine', NULL, '2025-12-12 14:28:48', '2025-12-12 14:28:48'),
(25, 'ORD-2025-000014', 20, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 54.00, 'in_ordine', NULL, '2025-12-12 14:30:00', '2025-12-12 14:30:00'),
(26, 'ORD-2025-000015', 21, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 54.00, 'in_ordine', NULL, '2025-12-12 14:31:59', '2025-12-12 14:31:59'),
(27, 'ORD-2025-000016', 22, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 54.00, 'in_ordine', NULL, '2025-12-12 14:33:05', '2025-12-12 14:33:05'),
(28, 'ORD-2025-000017', 23, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 58.00, 'in_ordine', NULL, '2025-12-12 14:34:28', '2025-12-12 14:34:28'),
(29, 'ORD-2025-000018', 24, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 20.00, 'in_ordine', NULL, '2025-12-12 14:35:13', '2025-12-12 14:35:13'),
(30, 'ORD-2025-000019', 25, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 144.00, 'in_ordine', NULL, '2025-12-12 14:36:01', '2025-12-12 14:36:01'),
(31, 'ORD-2025-000020', 26, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 145.00, 'in_ordine', NULL, '2025-12-12 14:37:06', '2025-12-12 14:37:06'),
(32, 'ORD-2025-000021', 27, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 54.00, 'in_ordine', NULL, '2025-12-12 14:37:50', '2025-12-12 14:37:50'),
(33, 'ORD-2025-000022', 28, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 56.00, 'in_ordine', NULL, '2025-12-12 14:39:15', '2025-12-12 14:39:15'),
(34, 'ORD-2025-000023', 29, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 55.00, 'in_ordine', NULL, '2025-12-12 14:40:12', '2025-12-12 14:40:12'),
(35, 'ORD-2025-000024', 30, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 77.00, 'in_ordine', NULL, '2025-12-12 14:41:44', '2025-12-12 14:41:44'),
(36, 'ORD-2025-000025', 31, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 79.00, 'in_ordine', NULL, '2025-12-12 14:48:01', '2025-12-12 14:48:01'),
(37, 'ORD-2025-000026', 32, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 78.00, 'in_ordine', 'ITALIA', '2025-12-12 16:19:52', '2025-12-12 16:19:52'),
(38, 'ORD-2025-000027', 33, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 55.00, 'in_ordine', NULL, '2025-12-12 16:21:33', '2025-12-12 16:21:33'),
(39, 'ORD-2025-000028', 34, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 54.00, 'in_ordine', NULL, '2025-12-12 16:22:39', '2025-12-12 16:22:39'),
(40, 'ORD-2025-000029', 35, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 78.00, 'in_ordine', NULL, '2025-12-12 16:34:20', '2025-12-12 16:34:20'),
(41, 'ORD-2025-000030', 36, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 77.00, 'in_ordine', NULL, '2025-12-12 16:42:19', '2025-12-12 16:42:19'),
(42, 'ORD-2025-000031', 37, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 54.00, 'in_ordine', NULL, '2025-12-12 16:42:55', '2025-12-12 16:42:55'),
(43, 'ORD-2025-000032', 38, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 30.00, 'in_ordine', NULL, '2025-12-12 16:43:56', '2025-12-12 16:43:56'),
(44, 'ORD-2025-000033', 39, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 77.00, 'in_ordine', NULL, '2025-12-12 16:44:51', '2025-12-12 16:44:51'),
(45, 'ORD-2025-000034', 40, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 79.00, 'in_ordine', NULL, '2025-12-12 16:45:55', '2025-12-12 16:45:55'),
(46, 'ORD-2025-000035', 41, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 30.00, 'in_ordine', NULL, '2025-12-12 16:46:44', '2025-12-12 16:46:44'),
(47, 'ORD-2025-000036', 42, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 55.00, 'in_ordine', NULL, '2025-12-12 16:47:39', '2025-12-12 16:47:39'),
(48, 'ORD-2025-000037', 43, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 54.00, 'in_ordine', NULL, '2025-12-12 16:48:16', '2025-12-12 16:48:16'),
(49, 'ORD-2025-000038', 44, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 78.00, 'in_ordine', NULL, '2025-12-12 16:49:01', '2025-12-12 16:49:01'),
(50, 'ORD-2025-000039', 45, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 45.00, 'in_ordine', NULL, '2025-12-12 16:49:59', '2025-12-12 16:49:59'),
(51, 'ORD-2025-000040', 46, NULL, '2025-12-12', '2026-01-31', 0.00, 0.00, 78.00, 'in_ordine', NULL, '2025-12-12 16:50:50', '2025-12-12 16:50:50');

-- =============================================
-- Struttura tabella `password_reset_tokens`
-- =============================================

DROP TABLE IF EXISTS `password_reset_tokens`;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `payments`
-- =============================================

DROP TABLE IF EXISTS `payments`;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `importo` decimal(10,2) NOT NULL,
  `data_pagamento` date NOT NULL,
  `metodo_pagamento` enum('contanti','bonifico','carta','assegno','altro') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'contanti',
  `stato` enum('in_attesa','completato','rifiutato') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'in_attesa',
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payments_order_id_foreign` (`order_id`),
  CONSTRAINT `payments_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `permission_role`
-- =============================================

DROP TABLE IF EXISTS `permission_role`;
CREATE TABLE `permission_role` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permission_role_permission_id_role_id_unique` (`permission_id`,`role_id`),
  KEY `permission_role_role_id_foreign` (`role_id`),
  CONSTRAINT `permission_role_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `permission_role_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `permission_role` (20 righe)

INSERT INTO `permission_role` (`id`, `permission_id`, `role_id`, `created_at`, `updated_at`) VALUES
(1, 1, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(2, 2, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(3, 3, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(4, 4, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(5, 5, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(6, 6, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(7, 7, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(8, 8, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(9, 9, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(10, 10, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(11, 11, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(12, 12, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(13, 13, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(14, 14, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(15, 12, 2, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(16, 14, 2, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(17, 13, 2, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(18, 11, 2, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(19, 1, 2, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(20, 11, 3, '2025-12-01 11:04:37', '2025-12-01 11:04:37');

-- =============================================
-- Struttura tabella `permissions`
-- =============================================

DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_unique` (`name`),
  UNIQUE KEY `permissions_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `permissions` (14 righe)

INSERT INTO `permissions` (`id`, `name`, `slug`, `description`, `group`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Visualizzare Utenti', 'users.view', 'Permette di visualizzare la lista degli utenti', 'users', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(2, 'Creare Utenti', 'users.create', 'Permette di creare nuovi utenti', 'users', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(3, 'Modificare Utenti', 'users.edit', 'Permette di modificare gli utenti esistenti', 'users', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(4, 'Eliminare Utenti', 'users.delete', 'Permette di eliminare gli utenti', 'users', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(5, 'Visualizzare Ruoli', 'roles.view', 'Permette di visualizzare la lista dei ruoli', 'roles', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(6, 'Creare Ruoli', 'roles.create', 'Permette di creare nuovi ruoli', 'roles', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(7, 'Modificare Ruoli', 'roles.edit', 'Permette di modificare i ruoli esistenti', 'roles', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(8, 'Eliminare Ruoli', 'roles.delete', 'Permette di eliminare i ruoli', 'roles', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(9, 'Visualizzare Permessi', 'permissions.view', 'Permette di visualizzare la lista dei permessi', 'permissions', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(10, 'Gestire Permessi', 'permissions.manage', 'Permette di gestire i permessi', 'permissions', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(11, 'Visualizzare Prodotti', 'products.view', 'Permette di visualizzare i prodotti', 'products', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(12, 'Creare Prodotti', 'products.create', 'Permette di creare nuovi prodotti', 'products', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(13, 'Modificare Prodotti', 'products.edit', 'Permette di modificare i prodotti', 'products', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(14, 'Eliminare Prodotti', 'products.delete', 'Permette di eliminare i prodotti', 'products', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37');

-- =============================================
-- Struttura tabella `prodotti_finiti`
-- =============================================

DROP TABLE IF EXISTS `prodotti_finiti`;
CREATE TABLE `prodotti_finiti` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codice` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titolo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `caratteristiche` text COLLATE utf8mb4_unicode_ci,
  `barcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qrcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unita_misura_id` bigint unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `aliquota_iva_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `prodotti_finiti_codice_unique` (`codice`),
  UNIQUE KEY `prodotti_finiti_barcode_unique` (`barcode`),
  UNIQUE KEY `prodotti_finiti_qrcode_unique` (`qrcode`),
  KEY `prodotti_finiti_aliquota_iva_id_foreign` (`aliquota_iva_id`),
  KEY `prodotti_finiti_unita_misura_id_foreign` (`unita_misura_id`),
  CONSTRAINT `prodotti_finiti_aliquota_iva_id_foreign` FOREIGN KEY (`aliquota_iva_id`) REFERENCES `aliquote_iva` (`id`) ON DELETE SET NULL,
  CONSTRAINT `prodotti_finiti_unita_misura_id_foreign` FOREIGN KEY (`unita_misura_id`) REFERENCES `unita_di_misura` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `prodotti_finiti` (8 righe)

INSERT INTO `prodotti_finiti` (`id`, `codice`, `titolo`, `descrizione`, `caratteristiche`, `barcode`, `qrcode`, `unita_misura_id`, `foto`, `aliquota_iva_id`, `created_at`, `updated_at`) VALUES
(1, 'PF-SCP-001', 'S-Charger Plus', 'Caricatore Portatile', NULL, 'PF-SCP-001-OIDUPB', 'PF-SCP-001-OIDSMN', NULL, 'prodotti_finiti_foto/TSa7l6M0OjTQNGzARxG9IY9H6jATwgZn4YGfyLio.png', NULL, '2025-12-01 11:04:37', '2025-12-02 11:43:09'),
(2, 'PF-MCS-002', 'M-Charger Station', 'Caricatore Desktop', NULL, 8051234567892, 'PF-MCS-002-OJ2HMM', NULL, 'prodotti_finiti_foto/UWrax8d3ptYS5SfXou9RM050XfnyWnRfF4oGjeas.png', NULL, '2025-12-01 11:04:37', '2025-12-02 12:01:57'),
(3, 'PF-BAT-003', 'AA Captery ULTRA', NULL, NULL, 8051234567893, 'PF-BAT-003-QR', NULL, 'prodotti_finiti_foto/dAxOcRrboAdMWOfmlDrec8dLLDHoRNN2DrFdBZdy.png', NULL, '2025-12-01 11:04:37', '2025-12-04 13:44:20'),
(4, 'PF-BAT-004', 'AAA Captery ULTRA', NULL, NULL, 8051234567894, 'PF-BAT-004-QR', NULL, 'prodotti_finiti_foto/W9tdj9V51TcJC2uMhWcLJ99tAFaNRzxu1DJeIzFc.png', NULL, '2025-12-01 11:04:37', '2025-12-04 13:45:37'),
(5, 'PF-BAT-005', 'AA Captery Bridge', NULL, NULL, 8051234567895, 'PF-BAT-005-QR', NULL, 'prodotti_finiti_foto/lMtAucF4X7tE8Z2dpXvf96Sj4Ol9cPPgl6Oil6DZ.png', NULL, '2025-12-01 11:04:37', '2025-12-04 13:46:20'),
(6, 'PF-BAT-006', 'AAA Captery Bridge', NULL, NULL, NULL, NULL, NULL, 'prodotti_finiti_foto/V5ya4OMg0jNXUBkOm9KCNW75BlUkUymGwiAwKQQW.png', NULL, '2025-12-02 12:05:10', '2025-12-04 15:22:54'),
(7, 'PF-BAT-007', 'Adattatore AAA/AA', NULL, NULL, NULL, NULL, NULL, 'prodotti_finiti_foto/2TxQCdUSnUsPgTsrSkizK0q3OL33FEOsvO0b7gCN.png', NULL, '2025-12-04 13:28:48', '2025-12-04 13:28:48'),
(8, 'PF-CPM-001', 'CapterMeter', NULL, NULL, NULL, NULL, NULL, 'prodotti_finiti_foto/QFiau42a80XqsxXZyaNzfthClrbiL4d2CipN86Kb.png', NULL, '2025-12-05 17:45:39', '2025-12-09 09:24:45');

-- =============================================
-- Struttura tabella `prodotto_finito_documents`
-- =============================================

DROP TABLE IF EXISTS `prodotto_finito_documents`;
CREATE TABLE `prodotto_finito_documents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `prodotto_finito_id` bigint unsigned NOT NULL,
  `nome` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tipo di documento: modello_3d, datasheet, altro',
  `file_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_size` bigint unsigned DEFAULT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `prodotto_finito_documents_prodotto_finito_id_foreign` (`prodotto_finito_id`),
  CONSTRAINT `prodotto_finito_documents_prodotto_finito_id_foreign` FOREIGN KEY (`prodotto_finito_id`) REFERENCES `prodotti_finiti` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `role_user`
-- =============================================

DROP TABLE IF EXISTS `role_user`;
CREATE TABLE `role_user` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role_user_user_id_role_id_unique` (`user_id`,`role_id`),
  KEY `role_user_role_id_foreign` (`role_id`),
  CONSTRAINT `role_user_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `role_user` (2 righe)

INSERT INTO `role_user` (`id`, `user_id`, `role_id`, `created_at`, `updated_at`) VALUES
(1, 1, 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(2, 2, 2, '2025-12-01 11:04:37', '2025-12-01 11:04:37');

-- =============================================
-- Struttura tabella `roles`
-- =============================================

DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_unique` (`name`),
  UNIQUE KEY `roles_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `roles` (3 righe)

INSERT INTO `roles` (`id`, `name`, `slug`, `description`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Amministratore', 'admin', 'Ruolo con tutti i permessi', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(2, 'Manager', 'manager', 'Ruolo per la gestione operativa', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(3, 'Utente', 'user', 'Ruolo base per gli utenti', 1, '2025-12-01 11:04:37', '2025-12-01 11:04:37');

-- =============================================
-- Struttura tabella `sessions`
-- =============================================

DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `telescope_entries`
-- =============================================

DROP TABLE IF EXISTS `telescope_entries`;
CREATE TABLE `telescope_entries` (
  `sequence` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch_id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `family_hash` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `should_display_on_index` tinyint(1) NOT NULL DEFAULT '1',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`sequence`),
  UNIQUE KEY `telescope_entries_uuid_unique` (`uuid`),
  KEY `telescope_entries_batch_id_index` (`batch_id`),
  KEY `telescope_entries_family_hash_index` (`family_hash`),
  KEY `telescope_entries_created_at_index` (`created_at`),
  KEY `telescope_entries_type_should_display_on_index_index` (`type`,`should_display_on_index`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `telescope_entries` (28 righe)

INSERT INTO `telescope_entries` (`sequence`, `uuid`, `batch_id`, `family_hash`, `should_display_on_index`, `type`, `content`, `created_at`) VALUES
(1, 'a07cfeab-82b5-4245-8bc4-dffca9c14ae1', 'a07cfeab-8a48-4272-bba4-1d1d06d580e6', '04d0a6450a40d596428a8f8e44ebdd3e', 0, 'exception', '{\"class\":\"Illuminate\\\\View\\\\ViewException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Vite.php\",\"line\":946,\"message\":\"Vite manifest not found at: \\/var\\/www\\/html\\/public\\/build\\/manifest.json (View: \\/var\\/www\\/html\\/resources\\/views\\/layouts\\/app.blade.php) (View: \\/var\\/www\\/html\\/resources\\/views\\/layouts\\/app.blade.php)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Engines\\/PhpEngine.php\",\"line\":59},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Engines\\/CompilerEngine.php\",\"line\":76},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/View.php\",\"line\":208},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/View.php\",\"line\":191},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/View.php\",\"line\":160},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Response.php\",\"line\":78},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Response.php\",\"line\":34},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":939},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":906},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"937\":\"     *\",\"938\":\"     * @throws \\\\Illuminate\\\\Foundation\\\\ViteManifestNotFoundException\",\"939\":\"     *\\/\",\"940\":\"    protected function manifest($buildDirectory)\",\"941\":\"    {\",\"942\":\"        $path = $this->manifestPath($buildDirectory);\",\"943\":\"\",\"944\":\"        if (! isset(static::$manifests[$path])) {\",\"945\":\"            if (! is_file($path)) {\",\"946\":\"                throw new ViteManifestNotFoundException(\\\"Vite manifest not found at: $path\\\");\",\"947\":\"            }\",\"948\":\"\",\"949\":\"            static::$manifests[$path] = json_decode(file_get_contents($path), true);\",\"950\":\"        }\",\"951\":\"\",\"952\":\"        return static::$manifests[$path];\",\"953\":\"    }\",\"954\":\"\",\"955\":\"    \\/**\",\"956\":\"     * Get the path to the manifest file for the given build directory.\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":1}', '2025-12-01 11:04:50'),
(2, 'a07cfeab-88f9-4ce3-b1a3-84b905a21159', 'a07cfeab-8a48-4272-bba4-1d1d06d580e6', NULL, 1, 'request', '{\"ip_address\":\"172.18.0.6\",\"uri\":\"\\/\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"cookie\":\"********\",\"priority\":\"u=0, i\",\"accept-language\":\"it-IT,it;q=0.9,en-US;q=0.8,en;q=0.7\",\"accept-encoding\":\"gzip, deflate, br, zstd\",\"referer\":\"http:\\/\\/188.34.129.39:8081\\/\",\"sec-fetch-dest\":\"document\",\"sec-fetch-user\":\"?1\",\"sec-fetch-mode\":\"navigate\",\"sec-fetch-site\":\"cross-site\",\"accept\":\"text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7\",\"user-agent\":\"Mozilla\\/5.0 (X11; Linux x86_64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/141.0.0.0 Safari\\/537.36\",\"upgrade-insecure-requests\":\"1\",\"dnt\":\"1\",\"sec-ch-ua-platform\":\"\\\"Linux\\\"\",\"sec-ch-ua-mobile\":\"?0\",\"sec-ch-ua\":\"\\\"Google Chrome\\\";v=\\\"141\\\", \\\"Not?A_Brand\\\";v=\\\"8\\\", \\\"Chromium\\\";v=\\\"141\\\"\",\"cache-control\":\"max-age=0\",\"connection\":\"close\",\"x-real-ip\":\"93.40.225.225\",\"x-forwarded-for\":\"93.40.225.225\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":[],\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"http:\\/\\/rithema.widesolution.com\",\"route\":\"home\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Mon, 01 Dec 2025 11:04:50 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6Ik5JZEV2TWNBbHNMTHNieElNTVlHM3c9PSIsInZhbHVlIjoiWVllUlg1dkg2cDdCeFpSQWF3YmZ3S0lLRzhXZUs0MjJWckk3MkptdUUwd2RXTmFYbHdDQ284V3BWUFR2aEpmN3V5NFRRQ0Fib2JSTTdsaFk3MFBwOHVEOTlaVVZrTms4Tlc5by9UOURyRm4rLy9xcU1CajQ3WW1oY1c2SnBoZVgiLCJtYWMiOiIyNGM5NDRkNjkzMjJhMDllM2NhZTMyNjc5ZTQ0YWZlNDYxZDY2MGIzZjgxZThlNTFhMGM2OGYzMDI0ODMwMGUxIiwidGFnIjoiIn0%3D; expires=Mon, 01 Dec 2025 13:04:50 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; samesite=lax, rithema-magazzino-session=eyJpdiI6IllpRFJiNmR5N2VYdFJlcW1DL0xnc3c9PSIsInZhbHVlIjoiRlB0M2JtVU42U1NRZ1p6RWl3QmJSLzdXYldNaG0rM0tCOXhpelhYWCtLM2xiMXdmVEZ3NW83dDM2eEFzNmZiUmxneDFZaExUSzVUOWUxVTk3ZWFlSmpiVjFpVjBvWlMzWnZWUlpaRXVqbTg3R2t6dTVkR2lCSGNFaG42bmtRa24iLCJtYWMiOiI3NjhhYzg4YWViNGU3YTA5Njg1MjhkMmZjNDU0MmY1MzAzNzQ0MTk0YTNjZTE2YjdiYTRkNThlODU4NGU3ODU1IiwidGFnIjoiIn0%3D; expires=Mon, 01 Dec 2025 13:04:50 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":259,\"memory\":26,\"hostname\":\"22e2764f7c33\"}', '2025-12-01 11:04:50'),
(3, 'a07cfedd-0787-4b4b-a034-ab1c0075092d', 'a07cfedd-0b7a-40b6-9cf7-f0ee6c93708a', '04d0a6450a40d596428a8f8e44ebdd3e', 1, 'exception', '{\"class\":\"Illuminate\\\\View\\\\ViewException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Vite.php\",\"line\":946,\"message\":\"Vite manifest not found at: \\/var\\/www\\/html\\/public\\/build\\/manifest.json (View: \\/var\\/www\\/html\\/resources\\/views\\/layouts\\/app.blade.php) (View: \\/var\\/www\\/html\\/resources\\/views\\/layouts\\/app.blade.php)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Engines\\/PhpEngine.php\",\"line\":59},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Engines\\/CompilerEngine.php\",\"line\":76},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/View.php\",\"line\":208},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/View.php\",\"line\":191},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/View.php\",\"line\":160},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Response.php\",\"line\":78},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Response.php\",\"line\":34},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":939},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":906},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"937\":\"     *\",\"938\":\"     * @throws \\\\Illuminate\\\\Foundation\\\\ViteManifestNotFoundException\",\"939\":\"     *\\/\",\"940\":\"    protected function manifest($buildDirectory)\",\"941\":\"    {\",\"942\":\"        $path = $this->manifestPath($buildDirectory);\",\"943\":\"\",\"944\":\"        if (! isset(static::$manifests[$path])) {\",\"945\":\"            if (! is_file($path)) {\",\"946\":\"                throw new ViteManifestNotFoundException(\\\"Vite manifest not found at: $path\\\");\",\"947\":\"            }\",\"948\":\"\",\"949\":\"            static::$manifests[$path] = json_decode(file_get_contents($path), true);\",\"950\":\"        }\",\"951\":\"\",\"952\":\"        return static::$manifests[$path];\",\"953\":\"    }\",\"954\":\"\",\"955\":\"    \\/**\",\"956\":\"     * Get the path to the manifest file for the given build directory.\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":2}', '2025-12-01 11:05:22'),
(4, 'a07cfedd-0acb-48bb-90ad-51486305135c', 'a07cfedd-0b7a-40b6-9cf7-f0ee6c93708a', NULL, 1, 'request', '{\"ip_address\":\"172.18.0.6\",\"uri\":\"\\/\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"accept-encoding\":\"gzip, deflate, br\",\"priority\":\"u=0, i\",\"accept-language\":\"it-IT,it;q=0.9\",\"sec-fetch-mode\":\"navigate\",\"sec-fetch-site\":\"none\",\"accept\":\"text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,*\\/*;q=0.8\",\"upgrade-insecure-requests\":\"1\",\"user-agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.1 Mobile\\/15E148 Safari\\/604.1\",\"sec-fetch-dest\":\"document\",\"connection\":\"close\",\"x-real-ip\":\"176.200.11.71\",\"x-forwarded-for\":\"176.200.11.71\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":[],\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"http:\\/\\/rithema.widesolution.com\",\"route\":\"home\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Mon, 01 Dec 2025 11:05:22 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6InIrTEVjRjJ0MkJpN1llY0dtQ0xJM2c9PSIsInZhbHVlIjoiR1I3MGlxcTA4cHpuRHJzOFJmMXUyRVBUM2I0R2ZqbHNvdk4zK3F1cklqQlZ1SXRUL25kQ0dXYUw5T3VOYlB6a05XUUhPQzVwaU9kS0kzNVNYaCtQV2MvcjNTVFgvK3Z5THRmbUtwNkhReVdnNGwxUVVzM3VVVW1Ea1ZWdjdiQkciLCJtYWMiOiJhMzhjYmYwMDAwNWE3ZDA5NjI5MmU1NGNjNDQ1MTk3ZWUwNDBlMGZkNjU0MDNlNTkxMTBmMzQxNGQ3OWFiMzVlIiwidGFnIjoiIn0%3D; expires=Mon, 01 Dec 2025 13:05:22 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; samesite=lax, rithema-magazzino-session=eyJpdiI6ImVwSGxJNDlnY2gwRGJEVEh4aWdISHc9PSIsInZhbHVlIjoiaWZmclJqYzNvSTRMU2lWc2pzTkpYOXBic0hxVmlYeFBEMHdydnVZQS9LNDhzcHdJaDl1SEdKaWRsWmZnT3NMaDFVNFVPVTJNMGZ4d2IvQzNhVDlXU1RwUm90Q0N4cS9jVFUxSVhkc3FUM1ovL3JKRVg4OVN2OGhoSXZSZHBwMEgiLCJtYWMiOiIyYmJhZGQwODg2YzNhZmExMmM5NzcxMjQzOWRmNjQxNTc0ZDU5YzhhYWQ5MDljNzZiMGJjMDdhNzkzZjdlMTBmIiwidGFnIjoiIn0%3D; expires=Mon, 01 Dec 2025 13:05:22 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":278,\"memory\":26,\"hostname\":\"22e2764f7c33\"}', '2025-12-01 11:05:22'),
(5, 'a07e0639-6dbe-4f67-9970-7a2a3206b777', 'a07e0639-755d-4138-8568-75ae22c1ef9a', 'c6b236da76150c72996f30401be1e8bf', 0, 'exception', '{\"class\":\"Illuminate\\\\Database\\\\QueryException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":824,\"message\":\"SQLSTATE[HY000]: General error: 3065 Expression #1 of ORDER BY clause is not in SELECT list, references column \'am.prodotti_finiti.titolo\' which is not in SELECT list; this is incompatible with DISTINCT (Connection: mysql, SQL: select distinct `magazzino`.* from `magazzino` inner join `prodotti_finiti` on `magazzino`.`prodotto_finito_id` = `prodotti_finiti`.`id` order by `prodotti_finiti`.`titolo` asc)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":778},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":397},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3188},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3173},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3763},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3172},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":902},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":884},{\"file\":\"\\/var\\/www\\/html\\/app\\/Http\\/Controllers\\/MagazzinoController.php\",\"line\":60},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/ControllerDispatcher.php\",\"line\":46},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":265},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":211},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":822},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"815\":\"        \\/\\/ message to include the bindings with SQL, which will make this exception a\",\"816\":\"        \\/\\/ lot more helpful to the developer instead of just the database\'s errors.\",\"817\":\"        catch (Exception $e) {\",\"818\":\"            if ($this->isUniqueConstraintError($e)) {\",\"819\":\"                throw new UniqueConstraintViolationException(\",\"820\":\"                    $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"821\":\"                );\",\"822\":\"            }\",\"823\":\"\",\"824\":\"            throw new QueryException(\",\"825\":\"                $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"826\":\"            );\",\"827\":\"        }\",\"828\":\"    }\",\"829\":\"\",\"830\":\"    \\/**\",\"831\":\"     * Determine if the given database exception was caused by a unique constraint violation.\",\"832\":\"     *\",\"833\":\"     * @param  \\\\Exception  $exception\",\"834\":\"     * @return bool\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":1}', '2025-12-01 23:21:47'),
(6, 'a07e0639-7478-4367-ba30-141e3352ea4f', 'a07e0639-755d-4138-8568-75ae22c1ef9a', NULL, 1, 'request', '{\"ip_address\":\"172.18.0.6\",\"uri\":\"\\/magazzino?sort_by=prodotto&sort_order=asc\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"cookie\":\"********\",\"accept-encoding\":\"gzip, br, deflate\",\"user-agent\":\"Mozilla\\/5.0 AppleWebKit\\/537.36 (KHTML, like Gecko; compatible; GPTBot\\/1.3; +https:\\/\\/openai.com\\/gptbot)\",\"from\":\"gptbot(at)openai.com\",\"accept\":\"*\\/*\",\"x-openai-host-hash\":\"723777745\",\"connection\":\"close\",\"x-real-ip\":\"74.7.227.152\",\"x-forwarded-for\":\"74.7.227.152\",\"x-forwarded-proto\":\"http\",\"x-forwarded-scheme\":\"http\",\"host\":\"rithema.widesolution.com\"},\"payload\":{\"sort_by\":\"prodotto\",\"sort_order\":\"asc\"},\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"http:\\/\\/rithema.widesolution.com\\/magazzino?sort_by=prodotto&sort_order=asc\",\"route\":\"magazzino.index\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Mon, 01 Dec 2025 23:21:47 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6Ik1IMllvYnZ5bmp0L1M3S3UxZC9xaFE9PSIsInZhbHVlIjoiZUorM0NCY3FYZWFlZGVRVlUvd2Y0NUgvNDFJSGt6eGUrMW5Kd24yVGhiS2JONXR4WUNETmhOREM4NmJ0VDA5Zkx6L2NXZXBZVWlqdTQxZGZkSUpvM3VNZmJmdWtWNTJ5SjhwcGZ6bkU2U1FlRFJXbVVlRko1ejZpaWNGTVllMHEiLCJtYWMiOiIxNTc5NzgwMDkwZDExZjg3ZjMxZjYwOGQ5MTA2MTA3NTU4YjkxNzc3MDdhYTcxNTcyMWE5MGMzYWI3ZDQyNzgwIiwidGFnIjoiIn0%3D; expires=Tue, 02 Dec 2025 01:21:47 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; samesite=lax, rithema-magazzino-session=eyJpdiI6IlZieSt0UHRRUGxoMmdzTUFXVkpYMnc9PSIsInZhbHVlIjoieElwcHc5UVMrR2lwS09rd1p4RWVLSU9zSjF5UXJkSm1SMnVQT1kyenQ3VGs5S3V2clVyMFVIaFJHM2ZRRkc4OCtFNHQ2NFdPK0R4OGlQcEVhUVdEM2VJNXFQSzZJbUdkb0FYWDRLWWRodnR3SUtqYVFaY2xIelNuQzdoZlhQVHMiLCJtYWMiOiI3NjJkNzg5OGQzMTRmN2E1MGI4ODdmNzQyMGNlYzA1NzdlYjliYTZiZDk0M2IyNDY0MmMwNGExNzM3Nzc0YmZmIiwidGFnIjoiIn0%3D; expires=Tue, 02 Dec 2025 01:21:47 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":184,\"memory\":24,\"hostname\":\"22e2764f7c33\"}', '2025-12-01 23:21:47'),
(7, 'a082e637-beba-45d9-8911-0416135efd03', 'a082e637-c5d9-4042-9aba-02fa32684df4', 'c6b236da76150c72996f30401be1e8bf', 0, 'exception', '{\"class\":\"Illuminate\\\\Database\\\\QueryException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":824,\"message\":\"SQLSTATE[HY000]: General error: 3065 Expression #1 of ORDER BY clause is not in SELECT list, references column \'am.prodotti_finiti.titolo\' which is not in SELECT list; this is incompatible with DISTINCT (Connection: mysql, SQL: select distinct `magazzino`.* from `magazzino` inner join `prodotti_finiti` on `magazzino`.`prodotto_finito_id` = `prodotti_finiti`.`id` order by `prodotti_finiti`.`titolo` asc)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":778},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":397},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3188},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3173},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3763},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3172},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":902},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":884},{\"file\":\"\\/var\\/www\\/html\\/app\\/Http\\/Controllers\\/MagazzinoController.php\",\"line\":60},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/ControllerDispatcher.php\",\"line\":46},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":265},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":211},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":822},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"815\":\"        \\/\\/ message to include the bindings with SQL, which will make this exception a\",\"816\":\"        \\/\\/ lot more helpful to the developer instead of just the database\'s errors.\",\"817\":\"        catch (Exception $e) {\",\"818\":\"            if ($this->isUniqueConstraintError($e)) {\",\"819\":\"                throw new UniqueConstraintViolationException(\",\"820\":\"                    $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"821\":\"                );\",\"822\":\"            }\",\"823\":\"\",\"824\":\"            throw new QueryException(\",\"825\":\"                $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"826\":\"            );\",\"827\":\"        }\",\"828\":\"    }\",\"829\":\"\",\"830\":\"    \\/**\",\"831\":\"     * Determine if the given database exception was caused by a unique constraint violation.\",\"832\":\"     *\",\"833\":\"     * @param  \\\\Exception  $exception\",\"834\":\"     * @return bool\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":2}', '2025-12-04 09:31:26'),
(8, 'a082e637-c4d4-4dc4-84f1-6106a53d78ca', 'a082e637-c5d9-4042-9aba-02fa32684df4', NULL, 1, 'request', '{\"ip_address\":\"74.7.243.130\",\"uri\":\"\\/magazzino?sort_by=prodotto&sort_order=asc\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"cookie\":\"********\",\"accept-encoding\":\"gzip, br, deflate\",\"user-agent\":\"Mozilla\\/5.0 AppleWebKit\\/537.36 (KHTML, like Gecko; compatible; GPTBot\\/1.3; +https:\\/\\/openai.com\\/gptbot)\",\"from\":\"gptbot(at)openai.com\",\"accept\":\"*\\/*\",\"x-openai-host-hash\":\"723777745\",\"connection\":\"close\",\"x-real-ip\":\"74.7.243.130\",\"x-forwarded-for\":\"74.7.243.130\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":{\"sort_by\":\"prodotto\",\"sort_order\":\"asc\"},\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"https:\\/\\/rithema.widesolution.com\\/magazzino?sort_by=prodotto&sort_order=asc\",\"route\":\"magazzino.index\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Thu, 04 Dec 2025 09:31:26 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6Ii81WlVMUzVNeVBQWkh6dm1WNmxubkE9PSIsInZhbHVlIjoiT1hJYkx6YXY4SHlqMmcrUnF5cFZkc1VobmZKY1VaZ2R2ZDREZ2VSWEZGVFdTck1HNjd2WS8yamwvVjZLSjh3REdVMndSVUJrMlRDdDFMUXNKU0czRTB2OEVRN1NhMFVGOGFjanIvVHNHQytCeGE2dGVrbEM0d2diS3o5S0YvR1UiLCJtYWMiOiI5Mzk3ZDBhZDUwMDUyNDlmZDU4NGMyYjRjMmRiYzE4ZjMwZWZkOTI3M2YxZjg5ZThiMzcyZjU2OWQ3MWYzM2E0IiwidGFnIjoiIn0%3D; expires=Thu, 04 Dec 2025 11:31:26 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; samesite=lax, rithema-magazzino-session=eyJpdiI6InBZWUZnazltcmU3LzBiOGcrQlhrYUE9PSIsInZhbHVlIjoiTnEra3BrT2FpVWQzVEVKbmlwVGFOdVNZemdtUmF6OVFOeHBvMFlOaWU1cVVCclI4NWFwck9sMTZ0bEdxVVdpVXJueUhDdCtzWEhXdzhwY2JWSUpVc1pLbGJIenpOR1krcXRLVVR5d2tIUkdvY1VPNkhHUzEvU3dlbkdUSnkzLzUiLCJtYWMiOiJmZGJhNDkzMTAwOTBkNjAwZWZiYTQ2NzZhMTBmZjM2YmI1OWZjNjQ1ZDU4OTAzMzljYzBlYzIyNGExYzgxNjk2IiwidGFnIjoiIn0%3D; expires=Thu, 04 Dec 2025 11:31:26 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":183,\"memory\":24,\"hostname\":\"22e2764f7c33\"}', '2025-12-04 09:31:26'),
(9, 'a082e66b-3de0-4b6e-b68e-6b6d89bf9eb5', 'a082e66b-4472-4e41-b73e-68ed39d83d43', 'c6b236da76150c72996f30401be1e8bf', 0, 'exception', '{\"class\":\"Illuminate\\\\Database\\\\QueryException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":824,\"message\":\"SQLSTATE[HY000]: General error: 3065 Expression #1 of ORDER BY clause is not in SELECT list, references column \'am.prodotti_finiti.titolo\' which is not in SELECT list; this is incompatible with DISTINCT (Connection: mysql, SQL: select distinct `magazzino`.* from `magazzino` inner join `prodotti_finiti` on `magazzino`.`prodotto_finito_id` = `prodotti_finiti`.`id` order by `prodotti_finiti`.`titolo` asc)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":778},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":397},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3188},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3173},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3763},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3172},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":902},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":884},{\"file\":\"\\/var\\/www\\/html\\/app\\/Http\\/Controllers\\/MagazzinoController.php\",\"line\":60},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/ControllerDispatcher.php\",\"line\":46},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":265},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":211},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":822},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"815\":\"        \\/\\/ message to include the bindings with SQL, which will make this exception a\",\"816\":\"        \\/\\/ lot more helpful to the developer instead of just the database\'s errors.\",\"817\":\"        catch (Exception $e) {\",\"818\":\"            if ($this->isUniqueConstraintError($e)) {\",\"819\":\"                throw new UniqueConstraintViolationException(\",\"820\":\"                    $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"821\":\"                );\",\"822\":\"            }\",\"823\":\"\",\"824\":\"            throw new QueryException(\",\"825\":\"                $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"826\":\"            );\",\"827\":\"        }\",\"828\":\"    }\",\"829\":\"\",\"830\":\"    \\/**\",\"831\":\"     * Determine if the given database exception was caused by a unique constraint violation.\",\"832\":\"     *\",\"833\":\"     * @param  \\\\Exception  $exception\",\"834\":\"     * @return bool\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":3}', '2025-12-04 09:31:59'),
(10, 'a082e66b-4395-4f83-b5b8-042d30b65b5b', 'a082e66b-4472-4e41-b73e-68ed39d83d43', NULL, 1, 'request', '{\"ip_address\":\"74.7.243.130\",\"uri\":\"\\/magazzino?sort_by=prodotto&sort_order=asc\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"cookie\":\"********\",\"accept-encoding\":\"gzip, br, deflate\",\"user-agent\":\"Mozilla\\/5.0 AppleWebKit\\/537.36 (KHTML, like Gecko; compatible; GPTBot\\/1.3; +https:\\/\\/openai.com\\/gptbot)\",\"from\":\"gptbot(at)openai.com\",\"accept\":\"*\\/*\",\"x-openai-host-hash\":\"723777745\",\"connection\":\"close\",\"x-real-ip\":\"74.7.243.130\",\"x-forwarded-for\":\"74.7.243.130\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":{\"sort_by\":\"prodotto\",\"sort_order\":\"asc\"},\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"https:\\/\\/rithema.widesolution.com\\/magazzino?sort_by=prodotto&sort_order=asc\",\"route\":\"magazzino.index\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Thu, 04 Dec 2025 09:31:59 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6IlhoZ2k1SmZNeFAzYSt1dDk5TFV0ckE9PSIsInZhbHVlIjoiTitUK0xBZ1RpQ25aSDNSMVVTM2FqSkpnOUgySzQzUEVrODQyM1NCV1YxK25RRm9MUGJ4M0NuZDEzcDh3ejFySWVKVTlzRklXR3p3KzRna2o4VmJCQW5tcUZHcDZMcUNrdERmald2QVFJWnYyd21PNTdveENUd1I4VnVTYzhFNjEiLCJtYWMiOiI4NzAyNTY2MjdiOGI3NTdmNjUzMmFmMTFiMDI3YTNmMGQ5NDMwNjQyMDlhYWM2NWIzYzZjMTc2ZWE2ZGZiMDQ0IiwidGFnIjoiIn0%3D; expires=Thu, 04 Dec 2025 11:31:59 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; samesite=lax, rithema-magazzino-session=eyJpdiI6ImVqNE9nVnVWYWgvZlM1K1ZrbWE4bXc9PSIsInZhbHVlIjoiZk5xL0dvOGkxa0N4STQ5Y3BIVkRTRGRHVGt2ZmQ3SmJ2cDJqVW1BeHBqcFNQSlpFbkhoNzcvWGxpN25VdE9tdnVuUkkrN0pVN0ZJUHViVkVrckc1QUViMVl2Y0gxU0NYdXBFWjhkR296eExxZ3llRkFTeWJkZVpOWUYvbmEyVWMiLCJtYWMiOiJiY2UyMWZlYmE5OWI1NWE2NzlhY2EwNDhhOTg4NDY1ZjVkMGZjNDJiNzRjNjJkMzgzMjUxM2Q0NzVjZGJjNzljIiwidGFnIjoiIn0%3D; expires=Thu, 04 Dec 2025 11:31:59 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":175,\"memory\":24,\"hostname\":\"22e2764f7c33\"}', '2025-12-04 09:31:59'),
(11, 'a087da0c-aa20-4b98-b1b0-34f283e33f07', 'a087da0c-b171-4daf-a016-6b818d54c1a0', 'c6b236da76150c72996f30401be1e8bf', 0, 'exception', '{\"class\":\"Illuminate\\\\Database\\\\QueryException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":824,\"message\":\"SQLSTATE[HY000]: General error: 3065 Expression #1 of ORDER BY clause is not in SELECT list, references column \'am.prodotti_finiti.titolo\' which is not in SELECT list; this is incompatible with DISTINCT (Connection: mysql, SQL: select distinct `magazzino`.* from `magazzino` inner join `prodotti_finiti` on `magazzino`.`prodotto_finito_id` = `prodotti_finiti`.`id` order by `prodotti_finiti`.`titolo` asc)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":778},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":397},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3188},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3173},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3763},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3172},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":902},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":884},{\"file\":\"\\/var\\/www\\/html\\/app\\/Http\\/Controllers\\/MagazzinoController.php\",\"line\":60},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/ControllerDispatcher.php\",\"line\":46},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":265},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":211},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":822},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"815\":\"        \\/\\/ message to include the bindings with SQL, which will make this exception a\",\"816\":\"        \\/\\/ lot more helpful to the developer instead of just the database\'s errors.\",\"817\":\"        catch (Exception $e) {\",\"818\":\"            if ($this->isUniqueConstraintError($e)) {\",\"819\":\"                throw new UniqueConstraintViolationException(\",\"820\":\"                    $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"821\":\"                );\",\"822\":\"            }\",\"823\":\"\",\"824\":\"            throw new QueryException(\",\"825\":\"                $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"826\":\"            );\",\"827\":\"        }\",\"828\":\"    }\",\"829\":\"\",\"830\":\"    \\/**\",\"831\":\"     * Determine if the given database exception was caused by a unique constraint violation.\",\"832\":\"     *\",\"833\":\"     * @param  \\\\Exception  $exception\",\"834\":\"     * @return bool\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":4}', '2025-12-06 20:36:32'),
(12, 'a087da0c-b091-42c0-b0e0-64076469a9cf', 'a087da0c-b171-4daf-a016-6b818d54c1a0', NULL, 1, 'request', '{\"ip_address\":\"74.7.243.214\",\"uri\":\"\\/magazzino?sort_by=prodotto&sort_order=asc\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"cookie\":\"********\",\"accept-encoding\":\"gzip, br, deflate\",\"user-agent\":\"Mozilla\\/5.0 AppleWebKit\\/537.36 (KHTML, like Gecko; compatible; GPTBot\\/1.3; +https:\\/\\/openai.com\\/gptbot)\",\"from\":\"gptbot(at)openai.com\",\"accept\":\"*\\/*\",\"x-openai-host-hash\":\"723777745\",\"connection\":\"close\",\"x-real-ip\":\"74.7.243.214\",\"x-forwarded-for\":\"74.7.243.214\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":{\"sort_by\":\"prodotto\",\"sort_order\":\"asc\"},\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"https:\\/\\/rithema.widesolution.com\\/magazzino?sort_by=prodotto&sort_order=asc\",\"route\":\"magazzino.index\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Sat, 06 Dec 2025 20:36:32 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6IkRGdzM2R2NhalpnR0lKR0lJWE5MMVE9PSIsInZhbHVlIjoiMk1TZTZDQ3ZlditWemRyZEpXQVFuRkJKdCtkQmJKK1V1N2VlaU1vWFZSay96L0xkdjRlZHVPMUpTM1B6YTZnbFBMN25jUTkzdGVOa1Vva3hMSUFLbExjRXVhaHZPY1VNeW1JSnVFQmtlbjJkSWppMlhNRVBTV0QwV0dxc3h2NTIiLCJtYWMiOiJmYTAwZTJjZTg0NWI4OTNlZDk1NjZmNjIxNTJlMTg1ZDQyZDgxMmU0NjQ4MjQzNDk2ODczNDdhYTZkNmY0NTRlIiwidGFnIjoiIn0%3D; expires=Sat, 06 Dec 2025 22:36:32 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; samesite=lax, rithema-magazzino-session=eyJpdiI6InNPcU04YzNoZkRObVRmWkVkVU9nNHc9PSIsInZhbHVlIjoiZkhBL0hKTDVWTmVKWWdyU0lTeGVGdUxDeWZDOGFaQ2M4a04zZG5IcWFQc0k4aHI0SStGRnU3VEgzbHFPdGhEMTVJODF6L3pSSzhmblJTK2F2VDFTQ0hRLzhyS1BzeHN3a2JHWGZ5cU5sbkd4aUp0UTFyam5IRmFkQVFzaEM3UGMiLCJtYWMiOiJiZThmZjk1ODhkNDM1ZTIyODc2NDRiZjllODRhZTZiM2NkNzExOTNlYTBiM2VjODA3NjVmNTE0N2FkYWRhYzM0IiwidGFnIjoiIn0%3D; expires=Sat, 06 Dec 2025 22:36:32 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":206,\"memory\":24,\"hostname\":\"22e2764f7c33\"}', '2025-12-06 20:36:32'),
(13, 'a08ce91b-cc64-4008-8449-4954e38c0fcc', 'a08ce91b-d363-44e4-b04e-3a3799a0855a', 'c6b236da76150c72996f30401be1e8bf', 0, 'exception', '{\"class\":\"Illuminate\\\\Database\\\\QueryException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":824,\"message\":\"SQLSTATE[HY000]: General error: 3065 Expression #1 of ORDER BY clause is not in SELECT list, references column \'am.prodotti_finiti.titolo\' which is not in SELECT list; this is incompatible with DISTINCT (Connection: mysql, SQL: select distinct `magazzino`.* from `magazzino` inner join `prodotti_finiti` on `magazzino`.`prodotto_finito_id` = `prodotti_finiti`.`id` order by `prodotti_finiti`.`titolo` asc)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":778},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":397},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3188},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3173},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3763},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3172},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":902},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":884},{\"file\":\"\\/var\\/www\\/html\\/app\\/Http\\/Controllers\\/MagazzinoController.php\",\"line\":60},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/ControllerDispatcher.php\",\"line\":46},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":265},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":211},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":822},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"815\":\"        \\/\\/ message to include the bindings with SQL, which will make this exception a\",\"816\":\"        \\/\\/ lot more helpful to the developer instead of just the database\'s errors.\",\"817\":\"        catch (Exception $e) {\",\"818\":\"            if ($this->isUniqueConstraintError($e)) {\",\"819\":\"                throw new UniqueConstraintViolationException(\",\"820\":\"                    $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"821\":\"                );\",\"822\":\"            }\",\"823\":\"\",\"824\":\"            throw new QueryException(\",\"825\":\"                $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"826\":\"            );\",\"827\":\"        }\",\"828\":\"    }\",\"829\":\"\",\"830\":\"    \\/**\",\"831\":\"     * Determine if the given database exception was caused by a unique constraint violation.\",\"832\":\"     *\",\"833\":\"     * @param  \\\\Exception  $exception\",\"834\":\"     * @return bool\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":5}', '2025-12-09 08:57:47'),
(14, 'a08ce91b-d27a-4773-af58-7a6b9c5764c3', 'a08ce91b-d363-44e4-b04e-3a3799a0855a', NULL, 1, 'request', '{\"ip_address\":\"74.7.227.43\",\"uri\":\"\\/magazzino?sort_by=prodotto&sort_order=asc\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"cookie\":\"********\",\"accept-encoding\":\"gzip, br, deflate\",\"user-agent\":\"Mozilla\\/5.0 AppleWebKit\\/537.36 (KHTML, like Gecko; compatible; GPTBot\\/1.3; +https:\\/\\/openai.com\\/gptbot)\",\"from\":\"gptbot(at)openai.com\",\"accept\":\"*\\/*\",\"x-openai-host-hash\":\"723777745\",\"connection\":\"close\",\"x-real-ip\":\"74.7.227.43\",\"x-forwarded-for\":\"74.7.227.43\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":{\"sort_by\":\"prodotto\",\"sort_order\":\"asc\"},\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"https:\\/\\/rithema.widesolution.com\\/magazzino?sort_by=prodotto&sort_order=asc\",\"route\":\"magazzino.index\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Tue, 09 Dec 2025 08:57:47 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6IjIyVC9tZ21KM1AzZTFMemluRUNoVVE9PSIsInZhbHVlIjoiNitSamt0K2VrSHZXa2tZTUIwSnBLMVFjQStqTlFLVFlYTnRkT29Ga25aRWJPVmcvSUNFaFR2Y25ubEQ2bVdMbkxxWmVMa2JDL0F3dWtnZEluekZXS2VVaE5QeEt1ZjBnZGlPemNFdHZoRnVLM1RJNytYbktQTFEyaUFHYUNHbksiLCJtYWMiOiI0Mzc5ODM2YTg0YWZiMjVmN2M4ZGM3ZjM4ZjA3NTk4YTM4NzNkNTY2MWIyOWNkZDIzNjFmZjZkMWNkMGIyMTMwIiwidGFnIjoiIn0%3D; expires=Tue, 09 Dec 2025 10:57:47 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; samesite=lax, rithema-magazzino-session=eyJpdiI6Im9LbVBtWEhUKzBjcGoveGhUYStGYWc9PSIsInZhbHVlIjoiSFp2SjY3RGQ4UmMzOVJJcUNFL2g1b0x1UlFoU3dKZUFaWkJhTzQ0bWdNL1JFbzg1RFhPTVFpY2txdGVibjBHWVZMUXRYcG5seXAzSHRMUkhFdnRTQlBxQitSaTRFc0NVUSs3QU5JWEtxMXlwdkFiUGNjcHlIcVZGR1RQSXlSRVYiLCJtYWMiOiIyZGU1YjM1MzMyOTE2ZTU5OTEwY2I1MDg5OGM3Zjc0YmQ1OWQyMDc4MDIyYjllNGNiZjUxMDAzNzlkNzIwMDM2IiwidGFnIjoiIn0%3D; expires=Tue, 09 Dec 2025 10:57:47 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":191,\"memory\":24,\"hostname\":\"22e2764f7c33\"}', '2025-12-09 08:57:47'),
(15, 'a0913cf7-ff26-4e2b-b2d7-10aa3f4c8e12', 'a0913cf8-060c-4515-bca4-6bc0175c4fe7', 'c6b236da76150c72996f30401be1e8bf', 0, 'exception', '{\"class\":\"Illuminate\\\\Database\\\\QueryException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":824,\"message\":\"SQLSTATE[HY000]: General error: 3065 Expression #1 of ORDER BY clause is not in SELECT list, references column \'am.prodotti_finiti.titolo\' which is not in SELECT list; this is incompatible with DISTINCT (Connection: mysql, SQL: select distinct `magazzino`.* from `magazzino` inner join `prodotti_finiti` on `magazzino`.`prodotto_finito_id` = `prodotti_finiti`.`id` order by `prodotti_finiti`.`titolo` asc)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":778},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":397},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3188},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3173},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3763},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3172},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":902},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":884},{\"file\":\"\\/var\\/www\\/html\\/app\\/Http\\/Controllers\\/MagazzinoController.php\",\"line\":60},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/ControllerDispatcher.php\",\"line\":46},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":265},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":211},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":822},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"815\":\"        \\/\\/ message to include the bindings with SQL, which will make this exception a\",\"816\":\"        \\/\\/ lot more helpful to the developer instead of just the database\'s errors.\",\"817\":\"        catch (Exception $e) {\",\"818\":\"            if ($this->isUniqueConstraintError($e)) {\",\"819\":\"                throw new UniqueConstraintViolationException(\",\"820\":\"                    $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"821\":\"                );\",\"822\":\"            }\",\"823\":\"\",\"824\":\"            throw new QueryException(\",\"825\":\"                $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"826\":\"            );\",\"827\":\"        }\",\"828\":\"    }\",\"829\":\"\",\"830\":\"    \\/**\",\"831\":\"     * Determine if the given database exception was caused by a unique constraint violation.\",\"832\":\"     *\",\"833\":\"     * @param  \\\\Exception  $exception\",\"834\":\"     * @return bool\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":6}', '2025-12-11 12:35:35'),
(16, 'a0913cf8-050f-4f2d-99f3-a8e2e9531898', 'a0913cf8-060c-4515-bca4-6bc0175c4fe7', NULL, 1, 'request', '{\"ip_address\":\"74.7.227.60\",\"uri\":\"\\/magazzino?sort_by=prodotto&sort_order=asc\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"cookie\":\"********\",\"accept-encoding\":\"gzip, br, deflate\",\"user-agent\":\"Mozilla\\/5.0 AppleWebKit\\/537.36 (KHTML, like Gecko; compatible; GPTBot\\/1.3; +https:\\/\\/openai.com\\/gptbot)\",\"from\":\"gptbot(at)openai.com\",\"accept\":\"*\\/*\",\"x-openai-host-hash\":\"723777745\",\"connection\":\"close\",\"x-real-ip\":\"74.7.227.60\",\"x-forwarded-for\":\"74.7.227.60\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":{\"sort_by\":\"prodotto\",\"sort_order\":\"asc\"},\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"https:\\/\\/rithema.widesolution.com\\/magazzino?sort_by=prodotto&sort_order=asc\",\"route\":\"magazzino.index\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Thu, 11 Dec 2025 12:35:35 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6IkllQ21Sc0xjb0xRdFkvd1ZBaXZVZ1E9PSIsInZhbHVlIjoiUVZsYkpLMWdwL1crYms3WEM1SHJOeUhMRHUrZ2JENGpQc0cxRkh1L1k4eWVYcHBtV1lIRDBEWUxhaU5ZZU9weFFhWlVoTEJOMm1yKytOMkcvRXVpWko3R3ZlSzgzUGVhNjhFSDRYOHVRT3BISVQrZ2QrUmlXV05zb08vUkszbUsiLCJtYWMiOiIyYmQyZGY0ODZiN2U1YzUyMGYzZjljY2U2OTcxZWIxNjkwNmIwMDhiZTQ2MmUzZDQ2NWJkZTM4YTMxZTkyNjQ0IiwidGFnIjoiIn0%3D; expires=Thu, 11 Dec 2025 14:35:35 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; samesite=lax, rithema-magazzino-session=eyJpdiI6IjVkRVF4L0JQOUhwY1VtSUNRcjhxRWc9PSIsInZhbHVlIjoicEdVRHRUUzRLT09yOERLNEtHdnBUOTVOakdWU3plMTNMSGxHcC9uK2MxSkhiN3NpdHAxWXBTWXhybHlhMnBjOFNINWtSYVdoQmZ4ekg5QU42NDEyNXRkZnJQeG5mVjFxcVZyMXgvZFZlcDRZeFE0aWNKb2hDakU2VENuQmhOZ28iLCJtYWMiOiJhZDRkOTdkNjE1YWE3ODMxMjZjZjVlMzIyNGRiY2I5YzNmZTlhMjU1YTE5NjE1YzllNjE3MDcwMDkzN2JmMjE3IiwidGFnIjoiIn0%3D; expires=Thu, 11 Dec 2025 14:35:35 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":191,\"memory\":24,\"hostname\":\"22e2764f7c33\"}', '2025-12-11 12:35:35'),
(17, 'a09538ea-297f-4e27-a438-a05834e87a22', 'a09538ea-3104-4d81-8218-b7bb7f5f4ccf', 'c6b236da76150c72996f30401be1e8bf', 0, 'exception', '{\"class\":\"Illuminate\\\\Database\\\\QueryException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":824,\"message\":\"SQLSTATE[HY000]: General error: 3065 Expression #1 of ORDER BY clause is not in SELECT list, references column \'am.prodotti_finiti.titolo\' which is not in SELECT list; this is incompatible with DISTINCT (Connection: mysql, SQL: select distinct `magazzino`.* from `magazzino` inner join `prodotti_finiti` on `magazzino`.`prodotto_finito_id` = `prodotti_finiti`.`id` order by `prodotti_finiti`.`titolo` asc)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":778},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":397},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3188},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3173},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3763},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3172},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":902},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":884},{\"file\":\"\\/var\\/www\\/html\\/app\\/Http\\/Controllers\\/MagazzinoController.php\",\"line\":60},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/ControllerDispatcher.php\",\"line\":46},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":265},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":211},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":822},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"815\":\"        \\/\\/ message to include the bindings with SQL, which will make this exception a\",\"816\":\"        \\/\\/ lot more helpful to the developer instead of just the database\'s errors.\",\"817\":\"        catch (Exception $e) {\",\"818\":\"            if ($this->isUniqueConstraintError($e)) {\",\"819\":\"                throw new UniqueConstraintViolationException(\",\"820\":\"                    $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"821\":\"                );\",\"822\":\"            }\",\"823\":\"\",\"824\":\"            throw new QueryException(\",\"825\":\"                $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"826\":\"            );\",\"827\":\"        }\",\"828\":\"    }\",\"829\":\"\",\"830\":\"    \\/**\",\"831\":\"     * Determine if the given database exception was caused by a unique constraint violation.\",\"832\":\"     *\",\"833\":\"     * @param  \\\\Exception  $exception\",\"834\":\"     * @return bool\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":7}', '2025-12-13 12:07:34'),
(18, 'a09538ea-3002-406b-b592-efec6baa8509', 'a09538ea-3104-4d81-8218-b7bb7f5f4ccf', NULL, 1, 'request', '{\"ip_address\":\"104.37.27.120\",\"uri\":\"\\/magazzino?sort_by=prodotto&sort_order=asc\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"baggage\":\"sentry-trace_id=cac3d20b614a4bc6b4b7a87dfe150467,sentry-sample_rand=0.320255,sentry-environment=production,sentry-public_key=8852b701c38ae3b2e7483740415e8300\",\"sentry-trace\":\"cac3d20b614a4bc6b4b7a87dfe150467-16c96686bc364981\",\"cookie\":\"********\",\"accept-language\":\"en-us,en;q=0.5\",\"user-agent\":\"Mozilla\\/5.0 (Macintosh; U; PPC Mac OS X Mach-O; en-US; rv:1.4a) Gecko\\/20030401\",\"accept\":\"*\\/*\",\"accept-encoding\":\"gzip,deflate,identity\",\"connection\":\"close\",\"x-real-ip\":\"104.37.27.120\",\"x-forwarded-for\":\"104.37.27.120\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":{\"sort_by\":\"prodotto\",\"sort_order\":\"asc\"},\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"https:\\/\\/rithema.widesolution.com\\/magazzino?sort_by=prodotto&sort_order=asc\",\"route\":\"magazzino.index\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Sat, 13 Dec 2025 12:07:34 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6IkdBbjIrRnZ3MURqYnJOb1RLUHhKMVE9PSIsInZhbHVlIjoib2pDQVR5bzVwR3o2bHU1Q1JlNWFUOVRqTitoYkdBTlg0bnFYTmJXWm9BdllvYytyWVVtSlhJY2hwcS9EcTA0eGloYmNQMlRzSlhkY0wzWGdzaUFwZ2pSTlR1VmRud3dDYWhPTmlVOEUvMlI2Z2RjL0N5U2JqQlI3aGxRV29kMUoiLCJtYWMiOiJiYTkxZDlhOGI1MjhjYWEwNTBjYzQ3OTc3MDBjMjcxZmZmYzcwYmIwN2U3YTZlNmVjNWYzNTg2MjZlZDg0YWY2IiwidGFnIjoiIn0%3D; expires=Sat, 13 Dec 2025 14:07:34 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; samesite=lax, rithema-magazzino-session=eyJpdiI6IlpObGlFSy81MzhDeVFWb2VLTFBoQ2c9PSIsInZhbHVlIjoidWh5R2RsK3FwajdlY2ZZZFhlRFRvaFpXZ1VGNFNoRzVZRlQrUzlydEp2MS84YTlaZ1RhdkFTMGNXcHVuMkFlTFpmUHJDak4vUkREclpGc3hDamZYRm1ZQjdpcTVVd0VLUXpFVzVrNEl3c3NWUUkzQWo3bnRYV3dMaXhVejdrUUwiLCJtYWMiOiI5YjhjMGMzNmU1MzU5MDg5ZDJiNGRlM2U2YjZkOTY5ZmQxNGFjNjY2Yjg5NGM1OWYxYWUyOWM3Y2NmM2M5ZDJkIiwidGFnIjoiIn0%3D; expires=Sat, 13 Dec 2025 14:07:34 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":192,\"memory\":24,\"hostname\":\"22e2764f7c33\"}', '2025-12-13 12:07:34'),
(19, 'a09794b9-2bcc-4475-bd91-09ab05732db3', 'a09794b9-3335-4c5a-bc55-58b0e041d6d6', 'c6b236da76150c72996f30401be1e8bf', 0, 'exception', '{\"class\":\"Illuminate\\\\Database\\\\QueryException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":824,\"message\":\"SQLSTATE[HY000]: General error: 3065 Expression #1 of ORDER BY clause is not in SELECT list, references column \'am.prodotti_finiti.titolo\' which is not in SELECT list; this is incompatible with DISTINCT (Connection: mysql, SQL: select distinct `magazzino`.* from `magazzino` inner join `prodotti_finiti` on `magazzino`.`prodotto_finito_id` = `prodotti_finiti`.`id` order by `prodotti_finiti`.`titolo` asc)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":778},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":397},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3188},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3173},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3763},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3172},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":902},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":884},{\"file\":\"\\/var\\/www\\/html\\/app\\/Http\\/Controllers\\/MagazzinoController.php\",\"line\":60},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/ControllerDispatcher.php\",\"line\":46},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":265},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":211},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":822},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"815\":\"        \\/\\/ message to include the bindings with SQL, which will make this exception a\",\"816\":\"        \\/\\/ lot more helpful to the developer instead of just the database\'s errors.\",\"817\":\"        catch (Exception $e) {\",\"818\":\"            if ($this->isUniqueConstraintError($e)) {\",\"819\":\"                throw new UniqueConstraintViolationException(\",\"820\":\"                    $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"821\":\"                );\",\"822\":\"            }\",\"823\":\"\",\"824\":\"            throw new QueryException(\",\"825\":\"                $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"826\":\"            );\",\"827\":\"        }\",\"828\":\"    }\",\"829\":\"\",\"830\":\"    \\/**\",\"831\":\"     * Determine if the given database exception was caused by a unique constraint violation.\",\"832\":\"     *\",\"833\":\"     * @param  \\\\Exception  $exception\",\"834\":\"     * @return bool\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":8}', '2025-12-14 16:15:56'),
(20, 'a09794b9-3232-4d3a-b715-2d3b189c10f3', 'a09794b9-3335-4c5a-bc55-58b0e041d6d6', NULL, 1, 'request', '{\"ip_address\":\"74.7.241.0\",\"uri\":\"\\/magazzino?sort_by=prodotto&sort_order=asc\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"cookie\":\"********\",\"accept-encoding\":\"gzip, br, deflate\",\"user-agent\":\"Mozilla\\/5.0 AppleWebKit\\/537.36 (KHTML, like Gecko; compatible; GPTBot\\/1.3; +https:\\/\\/openai.com\\/gptbot)\",\"from\":\"gptbot(at)openai.com\",\"accept\":\"*\\/*\",\"x-openai-host-hash\":\"723777745\",\"connection\":\"close\",\"x-real-ip\":\"74.7.241.0\",\"x-forwarded-for\":\"74.7.241.0\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":{\"sort_by\":\"prodotto\",\"sort_order\":\"asc\"},\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"https:\\/\\/rithema.widesolution.com\\/magazzino?sort_by=prodotto&sort_order=asc\",\"route\":\"magazzino.index\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Sun, 14 Dec 2025 16:15:56 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6IlhVbVJIa1lLdTV1WHc5UGJqR3ZHbUE9PSIsInZhbHVlIjoiRnlUdHBjOU1FQkxCMmkyelhEaFBQQWY1aGRmdFVCR1VxbHdTQ0x0MGkxU2ozek5IRUZZL010OTNBTkFQZDk5b1VSbXFPQnMwQzFZMTR6L2xDeWFINU1mTGZkSUNSQlpaNkNqQzAvT202dDJxbTFKR09MZXJHOTBBYkw3ZVlCVWkiLCJtYWMiOiI4MDg0NmUxMTlmZDk4NmYwMWIxMjA3YzgzNjIyMDkyMzU3MjRjMGEzZWI2MDM1YjM4ODk2NWE5Zjc2YzMwZjVlIiwidGFnIjoiIn0%3D; expires=Sun, 14 Dec 2025 18:15:56 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; samesite=lax, rithema-magazzino-session=eyJpdiI6InJXaVlvcmVEbVRWMTREbGcxRUpkNVE9PSIsInZhbHVlIjoid3ZUT3JpQmpXM3NHWmhYSGNqSURtSC9lVnBUT1cxU0ExSjdidW9iRzNmdzNUbC9sY1JZaU43bVB4Y0Z2WWZOZG45cmI2U1V2L1hjSEd1RnVBbDRtTEQwRDN3VytuQ1hsb0lCY2ZkTWNNYlR6M2lTang1VnlCL3FWRmtWYlhyUlciLCJtYWMiOiIzMDIzMmU3ZWYxOTFjZjE5NzU1MmZhODUxM2Q1YTMwZjExYjg2MWI4ODA4OGQyNmNmZTdhOWUyYjVjOWVkZGZkIiwidGFnIjoiIn0%3D; expires=Sun, 14 Dec 2025 18:15:56 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":193,\"memory\":24,\"hostname\":\"22e2764f7c33\"}', '2025-12-14 16:15:56'),
(21, 'a09ce827-4c9a-4877-b4de-67f7d6640b56', 'a09ce827-541e-4e46-9981-c6b4ad26c52f', 'c6b236da76150c72996f30401be1e8bf', 0, 'exception', '{\"class\":\"Illuminate\\\\Database\\\\QueryException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":824,\"message\":\"SQLSTATE[HY000]: General error: 3065 Expression #1 of ORDER BY clause is not in SELECT list, references column \'am.prodotti_finiti.titolo\' which is not in SELECT list; this is incompatible with DISTINCT (Connection: mysql, SQL: select distinct `magazzino`.* from `magazzino` inner join `prodotti_finiti` on `magazzino`.`prodotto_finito_id` = `prodotti_finiti`.`id` order by `prodotti_finiti`.`titolo` asc)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":778},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":397},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3188},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3173},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3763},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3172},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":902},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":884},{\"file\":\"\\/var\\/www\\/html\\/app\\/Http\\/Controllers\\/MagazzinoController.php\",\"line\":60},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/ControllerDispatcher.php\",\"line\":46},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":265},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":211},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":822},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"815\":\"        \\/\\/ message to include the bindings with SQL, which will make this exception a\",\"816\":\"        \\/\\/ lot more helpful to the developer instead of just the database\'s errors.\",\"817\":\"        catch (Exception $e) {\",\"818\":\"            if ($this->isUniqueConstraintError($e)) {\",\"819\":\"                throw new UniqueConstraintViolationException(\",\"820\":\"                    $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"821\":\"                );\",\"822\":\"            }\",\"823\":\"\",\"824\":\"            throw new QueryException(\",\"825\":\"                $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"826\":\"            );\",\"827\":\"        }\",\"828\":\"    }\",\"829\":\"\",\"830\":\"    \\/**\",\"831\":\"     * Determine if the given database exception was caused by a unique constraint violation.\",\"832\":\"     *\",\"833\":\"     * @param  \\\\Exception  $exception\",\"834\":\"     * @return bool\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":9}', '2025-12-17 07:48:22'),
(22, 'a09ce827-530f-4cfd-ae0e-a58729595e11', 'a09ce827-541e-4e46-9981-c6b4ad26c52f', NULL, 1, 'request', '{\"ip_address\":\"74.7.227.51\",\"uri\":\"\\/magazzino?sort_by=prodotto&sort_order=asc\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"cookie\":\"********\",\"accept-encoding\":\"gzip, br, deflate\",\"user-agent\":\"Mozilla\\/5.0 AppleWebKit\\/537.36 (KHTML, like Gecko; compatible; GPTBot\\/1.3; +https:\\/\\/openai.com\\/gptbot)\",\"from\":\"gptbot(at)openai.com\",\"accept\":\"*\\/*\",\"x-openai-host-hash\":\"723777745\",\"connection\":\"close\",\"x-real-ip\":\"74.7.227.51\",\"x-forwarded-for\":\"74.7.227.51\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":{\"sort_by\":\"prodotto\",\"sort_order\":\"asc\"},\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"https:\\/\\/rithema.widesolution.com\\/magazzino?sort_by=prodotto&sort_order=asc\",\"route\":\"magazzino.index\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Wed, 17 Dec 2025 07:48:22 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6ImVCQXNKdUl5eFMwYllIbW9rT3JjUFE9PSIsInZhbHVlIjoiZjRWREFnMUpkYlpwV3pJOFhFbWY5cmdmSTJja09VdHhIMkpwc280Z0VORENJcTFjY3FDbUhld2tHU0VzVURCcFY2RGQ2enp0dTZVaXNSMlFTZEJiUkhDSUd6Y3VnY2x5WTVRYlNhYjVHS0oyWSt4YVltWktsQU5UN2Y4NEMwTWkiLCJtYWMiOiJhZTU1OThlYTAyOWRlOWU1YTdkNjFjMGM0N2NkODAyN2FhZjYwYmI2NGI3NWZjNDFmMGRmYzFhODc4Y2NlYTcyIiwidGFnIjoiIn0%3D; expires=Wed, 17 Dec 2025 09:48:22 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; samesite=lax, rithema-magazzino-session=eyJpdiI6IlVoMkhvbE55Y1FnNWFwdkx3M1Btenc9PSIsInZhbHVlIjoiZlNvR3VER2xYNWZYYmRFSGd3eVhuZzBpd3ljcHpHZ0xLR013THpuRFF5NkIrOVp4OVU4K25ZbUFlVmxGU0ptdU95cGlaZDhSVjdOdHFLZmRUSFFVMXBMV1k2azlNSUh5YXpJRlpmMUxkcFMxUWtoUTE3bW1DQ1NYZEg3R0FjZE4iLCJtYWMiOiI3NTVjZjdlMzYyYmYzZDcxMDQ0ODI3Yjc5YTNkNjNmNWYwYzJiZDc3YWMxY2ZkMWZmZjM2YmE3ODRmNDY4ZDAzIiwidGFnIjoiIn0%3D; expires=Wed, 17 Dec 2025 09:48:22 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":202,\"memory\":24,\"hostname\":\"22e2764f7c33\"}', '2025-12-17 07:48:22'),
(23, 'a0b2e944-e925-4734-a167-5a6bc9867a36', 'a0b2e944-f08e-4e34-95c5-2c1fb7986a81', 'c6b236da76150c72996f30401be1e8bf', 0, 'exception', '{\"class\":\"Illuminate\\\\Database\\\\QueryException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":824,\"message\":\"SQLSTATE[HY000]: General error: 3065 Expression #1 of ORDER BY clause is not in SELECT list, references column \'am.prodotti_finiti.titolo\' which is not in SELECT list; this is incompatible with DISTINCT (Connection: mysql, SQL: select distinct `magazzino`.* from `magazzino` inner join `prodotti_finiti` on `magazzino`.`prodotto_finito_id` = `prodotti_finiti`.`id` order by `prodotti_finiti`.`titolo` asc)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":778},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":397},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3188},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3173},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3763},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3172},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":902},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":884},{\"file\":\"\\/var\\/www\\/html\\/app\\/Http\\/Controllers\\/MagazzinoController.php\",\"line\":60},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/ControllerDispatcher.php\",\"line\":46},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":265},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":211},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":822},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"815\":\"        \\/\\/ message to include the bindings with SQL, which will make this exception a\",\"816\":\"        \\/\\/ lot more helpful to the developer instead of just the database\'s errors.\",\"817\":\"        catch (Exception $e) {\",\"818\":\"            if ($this->isUniqueConstraintError($e)) {\",\"819\":\"                throw new UniqueConstraintViolationException(\",\"820\":\"                    $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"821\":\"                );\",\"822\":\"            }\",\"823\":\"\",\"824\":\"            throw new QueryException(\",\"825\":\"                $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"826\":\"            );\",\"827\":\"        }\",\"828\":\"    }\",\"829\":\"\",\"830\":\"    \\/**\",\"831\":\"     * Determine if the given database exception was caused by a unique constraint violation.\",\"832\":\"     *\",\"833\":\"     * @param  \\\\Exception  $exception\",\"834\":\"     * @return bool\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":10}', '2025-12-28 06:19:42'),
(24, 'a0b2e944-efa8-4128-ade3-9cb06eccefb8', 'a0b2e944-f08e-4e34-95c5-2c1fb7986a81', NULL, 1, 'request', '{\"ip_address\":\"45.148.10.160\",\"uri\":\"\\/magazzino?sort_by=prodotto&sort_order=asc\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"user-agent\":\"Mozilla\\/5.0 (Windows NT 6.1; Win64; x64; rv:47.0) Gecko\\/20100101 Firefox\\/47.0\",\"connection\":\"close\",\"x-real-ip\":\"45.148.10.160\",\"x-forwarded-for\":\"45.148.10.160\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":{\"sort_by\":\"prodotto\",\"sort_order\":\"asc\"},\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"https:\\/\\/rithema.widesolution.com\\/magazzino?sort_by=prodotto&sort_order=asc\",\"route\":\"magazzino.index\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Sun, 28 Dec 2025 06:19:42 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6ImtsR205SGV0SmVDb0VWam4zZ1BwU1E9PSIsInZhbHVlIjoicHdBMVNPK1BkTWdPV2JyY0FOczdZV2puWG5zTmgwcEtsam9ad0hnSnhFK2ZmcUNrUytTVi84b1NzTXJmcVY2Q0NvRlFzNDZpZVpsRUV3Q3VWdHpSNTJPcVVHVDJJQ3FTOFFyMG9zYyt5VGpLbUh0UEJ4RW0xaGxzUE03WkZUMU8iLCJtYWMiOiIzYjNiYjFhZWNmMzZiZDEwNjcxODlkYWVjMDE2YWQ4OWUxMzU4ZjU0OTdhOGE3ZGJhNGI5ZjQ2NjFkOGMxNmJlIiwidGFnIjoiIn0%3D; expires=Sun, 28 Dec 2025 08:19:42 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; samesite=lax, rithema-magazzino-session=eyJpdiI6IkNjOHpoWVlXL3ZHNlJwTngwUng5aFE9PSIsInZhbHVlIjoiTktYdE4vaXhPcGd1N1pEb2YyNXE1TUdKc3FTQ0dmQUdIWnZuYlpyNkF6ZmMwVmRFMCtSRk1VOS9hQUF4SnpyaWczZzhiY05ITCtUUlU3Sk1yayt0NnF6QWxkUlIzZ0d2T2RxNm5jZVdTNXRaU1U2dm5WNWpmVzdhM1VDNWUyZnQiLCJtYWMiOiJmYjIzMGVhZjJhNmQ0MGVlN2I1NjU1YzIxN2ExYWQ3YmNiYWQzNGZjZWUzN2NjZGQ0OTU3YTAzZmFhNGI4MGZiIiwidGFnIjoiIn0%3D; expires=Sun, 28 Dec 2025 08:19:42 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":191,\"memory\":24,\"hostname\":\"22e2764f7c33\"}', '2025-12-28 06:19:42'),
(25, 'a0b2e94e-3e24-4754-b500-ba3f5c1bdded', 'a0b2e94e-4535-498a-b2e1-197a94293a1b', 'c6b236da76150c72996f30401be1e8bf', 0, 'exception', '{\"class\":\"Illuminate\\\\Database\\\\QueryException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":824,\"message\":\"SQLSTATE[HY000]: General error: 3065 Expression #1 of ORDER BY clause is not in SELECT list, references column \'am.prodotti_finiti.titolo\' which is not in SELECT list; this is incompatible with DISTINCT (Connection: mysql, SQL: select distinct `magazzino`.* from `magazzino` inner join `prodotti_finiti` on `magazzino`.`prodotto_finito_id` = `prodotti_finiti`.`id` order by `prodotti_finiti`.`titolo` asc)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":778},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":397},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3188},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3173},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3763},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3172},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":902},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":884},{\"file\":\"\\/var\\/www\\/html\\/app\\/Http\\/Controllers\\/MagazzinoController.php\",\"line\":60},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/ControllerDispatcher.php\",\"line\":46},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":265},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":211},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":822},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"815\":\"        \\/\\/ message to include the bindings with SQL, which will make this exception a\",\"816\":\"        \\/\\/ lot more helpful to the developer instead of just the database\'s errors.\",\"817\":\"        catch (Exception $e) {\",\"818\":\"            if ($this->isUniqueConstraintError($e)) {\",\"819\":\"                throw new UniqueConstraintViolationException(\",\"820\":\"                    $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"821\":\"                );\",\"822\":\"            }\",\"823\":\"\",\"824\":\"            throw new QueryException(\",\"825\":\"                $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"826\":\"            );\",\"827\":\"        }\",\"828\":\"    }\",\"829\":\"\",\"830\":\"    \\/**\",\"831\":\"     * Determine if the given database exception was caused by a unique constraint violation.\",\"832\":\"     *\",\"833\":\"     * @param  \\\\Exception  $exception\",\"834\":\"     * @return bool\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":11}', '2025-12-28 06:19:48'),
(26, 'a0b2e94e-444a-4769-a873-d7347a9697db', 'a0b2e94e-4535-498a-b2e1-197a94293a1b', NULL, 1, 'request', '{\"ip_address\":\"45.148.10.160\",\"uri\":\"\\/magazzino?sort_by=prodotto&sort_order=asc\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"user-agent\":\"Mozilla\\/5.0 (Windows NT 6.1; Win64; x64; rv:47.0) Gecko\\/20100101 Firefox\\/47.0\",\"connection\":\"close\",\"x-real-ip\":\"45.148.10.160\",\"x-forwarded-for\":\"45.148.10.160\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":{\"sort_by\":\"prodotto\",\"sort_order\":\"asc\"},\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"https:\\/\\/rithema.widesolution.com\\/magazzino?sort_by=prodotto&sort_order=asc\",\"route\":\"magazzino.index\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Sun, 28 Dec 2025 06:19:48 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6IlF3L0p5K2Z1STZqMVNqb05VVU1CMHc9PSIsInZhbHVlIjoibThMVDg5dW9yWStkNDg5OGJmVzRRU0UyU2Y2RWlJc29PWGhJVjdRblloMmxDUjRLOVNSNXg5dUtITUhCeWxHYXcvSUNMVEhVb2ltYUhmSGttRWVTdjUvbGFmN3VtUkF6cGZkSnhLZFppOWhBVGJMWWdld0N4VE94OGNQS3Ztc1UiLCJtYWMiOiJlZDkwMjY4YjZmODJlNWMxMzI0NWQwMzVhZTM4ZGVkODgzZTRjYjZhMTgwYTgxNGUzOWE2ODhjODg0MTBiZWVmIiwidGFnIjoiIn0%3D; expires=Sun, 28 Dec 2025 08:19:48 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; samesite=lax, rithema-magazzino-session=eyJpdiI6Ik1EWFY4YVUrd3F3bTNkTFJkTFBrRkE9PSIsInZhbHVlIjoiNFllZGpaWVFuMGJIMUVPY2tjMWVoQmJkYXdkLzlqMW5Sb3RBZ3UzMXlIWE5YVjVubUxvM1ZVRnNMYitzMXR4SjZoMWQraEhtYldCa1lmRFc2Z2dOZ1gwSS9KRSthOU5KeU1VUnhDSXpnS3ZQU1dYbThXK08rOEdVNUk5RmZrV3MiLCJtYWMiOiI2ODJhMDk2YzgzNzg1NDRmN2YyMzNjNDBiY2I0YTI5OGNkODYxZDhlN2I0Mjc0YjE0MzNmNTMxNjM4MWYzYTE0IiwidGFnIjoiIn0%3D; expires=Sun, 28 Dec 2025 08:19:48 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":177,\"memory\":24,\"hostname\":\"22e2764f7c33\"}', '2025-12-28 06:19:48'),
(27, 'a0b2e955-3aae-42c2-865c-6e6bc12e5b12', 'a0b2e955-41dc-44e0-a5d0-3bb9792333e1', 'c6b236da76150c72996f30401be1e8bf', 1, 'exception', '{\"class\":\"Illuminate\\\\Database\\\\QueryException\",\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":824,\"message\":\"SQLSTATE[HY000]: General error: 3065 Expression #1 of ORDER BY clause is not in SELECT list, references column \'am.prodotti_finiti.titolo\' which is not in SELECT list; this is incompatible with DISTINCT (Connection: mysql, SQL: select distinct `magazzino`.* from `magazzino` inner join `prodotti_finiti` on `magazzino`.`prodotto_finito_id` = `prodotti_finiti`.`id` order by `prodotti_finiti`.`titolo` asc)\",\"context\":null,\"trace\":[{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":778},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Connection.php\",\"line\":397},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3188},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3173},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3763},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Query\\/Builder.php\",\"line\":3172},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":902},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Database\\/Eloquent\\/Builder.php\",\"line\":884},{\"file\":\"\\/var\\/www\\/html\\/app\\/Http\\/Controllers\\/MagazzinoController.php\",\"line\":60},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/ControllerDispatcher.php\",\"line\":46},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":265},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Route.php\",\"line\":211},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":822},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Middleware\\/SubstituteBindings.php\",\"line\":50},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/VerifyCsrfToken.php\",\"line\":87},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/View\\/Middleware\\/ShareErrorsFromSession.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":120},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Session\\/Middleware\\/StartSession.php\",\"line\":63},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/AddQueuedCookiesToResponse.php\",\"line\":36},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Cookie\\/Middleware\\/EncryptCookies.php\",\"line\":74},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":821},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":800},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":764},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Routing\\/Router.php\",\"line\":753},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":200},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":180},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/ConvertEmptyStringsToNull.php\",\"line\":31},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TransformsRequest.php\",\"line\":21},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/TrimStrings.php\",\"line\":51},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePostSize.php\",\"line\":27},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/PreventRequestsDuringMaintenance.php\",\"line\":109},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/HandleCors.php\",\"line\":48},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/TrustProxies.php\",\"line\":58},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Middleware\\/InvokeDeferredCallbacks.php\",\"line\":22},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Http\\/Middleware\\/ValidatePathEncoding.php\",\"line\":26},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":219},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Pipeline\\/Pipeline.php\",\"line\":137},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":175},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Http\\/Kernel.php\",\"line\":144},{\"file\":\"\\/var\\/www\\/html\\/vendor\\/laravel\\/framework\\/src\\/Illuminate\\/Foundation\\/Application.php\",\"line\":1220},{\"file\":\"\\/var\\/www\\/html\\/public\\/index.php\",\"line\":20}],\"line_preview\":{\"815\":\"        \\/\\/ message to include the bindings with SQL, which will make this exception a\",\"816\":\"        \\/\\/ lot more helpful to the developer instead of just the database\'s errors.\",\"817\":\"        catch (Exception $e) {\",\"818\":\"            if ($this->isUniqueConstraintError($e)) {\",\"819\":\"                throw new UniqueConstraintViolationException(\",\"820\":\"                    $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"821\":\"                );\",\"822\":\"            }\",\"823\":\"\",\"824\":\"            throw new QueryException(\",\"825\":\"                $this->getName(), $query, $this->prepareBindings($bindings), $e\",\"826\":\"            );\",\"827\":\"        }\",\"828\":\"    }\",\"829\":\"\",\"830\":\"    \\/**\",\"831\":\"     * Determine if the given database exception was caused by a unique constraint violation.\",\"832\":\"     *\",\"833\":\"     * @param  \\\\Exception  $exception\",\"834\":\"     * @return bool\"},\"hostname\":\"22e2764f7c33\",\"occurrences\":12}', '2025-12-28 06:19:53'),
(28, 'a0b2e955-40df-491e-8a85-f874b2b1299d', 'a0b2e955-41dc-44e0-a5d0-3bb9792333e1', NULL, 1, 'request', '{\"ip_address\":\"45.148.10.160\",\"uri\":\"\\/magazzino?sort_by=prodotto&sort_order=asc\",\"method\":\"GET\",\"controller_action\":\"App\\\\Http\\\\Controllers\\\\MagazzinoController@index\",\"middleware\":[\"web\"],\"headers\":{\"user-agent\":\"Mozilla\\/5.0 (Windows NT 6.1; Win64; x64; rv:47.0) Gecko\\/20100101 Firefox\\/47.0\",\"connection\":\"close\",\"x-real-ip\":\"45.148.10.160\",\"x-forwarded-for\":\"45.148.10.160\",\"x-forwarded-proto\":\"https\",\"x-forwarded-scheme\":\"https\",\"host\":\"rithema.widesolution.com\"},\"payload\":{\"sort_by\":\"prodotto\",\"sort_order\":\"asc\"},\"session\":{\"_token\":\"********\",\"_previous\":{\"url\":\"https:\\/\\/rithema.widesolution.com\\/magazzino?sort_by=prodotto&sort_order=asc\",\"route\":\"magazzino.index\"},\"_flash\":{\"old\":[],\"new\":[]}},\"response_headers\":{\"cache-control\":\"no-cache, private\",\"date\":\"Sun, 28 Dec 2025 06:19:53 GMT\",\"content-type\":\"text\\/html; charset=UTF-8\",\"set-cookie\":\"XSRF-TOKEN=eyJpdiI6IkxiUkNSR1l2bHZWS3Z6V0JQTFpuUkE9PSIsInZhbHVlIjoiZ0FabUN1NEZYYUt0R0ZKSktxWWZTRGNaL3k0Nk85THhuSys3c1dPSlhOWE9zQUtNUGpYSUd0Mlc5R2ZCQ3hXb0daR1IvUG9rOXNKZnI2YjYxdFloSkNWRDFlM20rQlFLU3BIV3VRdkhYS3l5T05DUU1tc1lMTjdCSkVISThtWWYiLCJtYWMiOiJjNjgyYTA5M2U0MjY5MDFlYzkxMzM2NWYyNTY4NzJmODBmNGNiODkyMWE5NzgxZGE4MjY4OGFhMDM0M2Y1NzljIiwidGFnIjoiIn0%3D; expires=Sun, 28 Dec 2025 08:19:53 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; samesite=lax, rithema-magazzino-session=eyJpdiI6ImRaTzBPMkg0OW1BRTU0bEFRdDg0dVE9PSIsInZhbHVlIjoiVEZqM1d4a1F6RDBtZXlXdENUblpzaFV3WWkvZzZVYVk3eU00bjVONDNHOHVLWUl3ak5aSmVMakR3U1l2KzBZZGJUSitXTWhyU1RBRS9HWGlwK3podzA4NmFqR3dPUThRMFIvV2tBMVJteTh3cUFlc0o2SUFDcDdnYzNHaXZXdWgiLCJtYWMiOiI2ZjI2YWE0NmEwN2YzYjhkNGE2NzM5OGU4Yzk1MDlhZWY2YjM2NWU0OGY4NmFmOTQ1YmE2NmE3OGI4ZGQ0NTM4IiwidGFnIjoiIn0%3D; expires=Sun, 28 Dec 2025 08:19:53 GMT; Max-Age=7200; path=\\/; domain=rithema.widesolution.com; secure; httponly; samesite=lax\"},\"response_status\":500,\"response\":\"HTML Response\",\"duration\":179,\"memory\":24,\"hostname\":\"22e2764f7c33\"}', '2025-12-28 06:19:53');

-- =============================================
-- Struttura tabella `telescope_entries_tags`
-- =============================================

DROP TABLE IF EXISTS `telescope_entries_tags`;
CREATE TABLE `telescope_entries_tags` (
  `entry_uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`entry_uuid`,`tag`),
  KEY `telescope_entries_tags_tag_index` (`tag`),
  CONSTRAINT `telescope_entries_tags_entry_uuid_foreign` FOREIGN KEY (`entry_uuid`) REFERENCES `telescope_entries` (`uuid`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `telescope_monitoring`
-- =============================================

DROP TABLE IF EXISTS `telescope_monitoring`;
CREATE TABLE `telescope_monitoring` (
  `tag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `unita_di_misura`
-- =============================================

DROP TABLE IF EXISTS `unita_di_misura`;
CREATE TABLE `unita_di_misura` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codice` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `simbolo` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `descrizione` text COLLATE utf8mb4_unicode_ci,
  `attiva` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unita_di_misura_codice_unique` (`codice`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- Struttura tabella `users`
-- =============================================

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dati tabella `users` (2 righe)

INSERT INTO `users` (`id`, `name`, `email`, `email_verified_at`, `password`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, 'Amministratore', 'admin@example.com', '2025-12-01 11:04:37', '$2y$12$mi6cYufLBR4d4L1O4i7OnuLDGNxNhdgvm/74LM3iViKqU296LKmdG', NULL, '2025-12-01 11:04:37', '2025-12-01 11:04:37'),
(2, 'Manager', 'manager@example.com', '2025-12-01 11:04:37', '$2y$12$iCt7Gd.RHRJfgyk4jih8JOPeApqu4knH9lpKtWpD2UYJt9ZeQHOOi', NULL, '2025-12-01 11:04:37', '2025-12-01 11:04:37');

SET FOREIGN_KEY_CHECKS=1;
COMMIT;
